/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.entity.ScheduledEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TimePeriod;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ReportCreator;
import com.moveworkforward.report.PayloadDataHolder;
import com.moveworkforward.util.ConnectorUtil;
import java.io.Serializable;

public abstract class AbstractReportCreator<T extends ScheduledEntity, P extends PayloadDataHolder>
implements ReportCreator<T, P> {
    protected final I18nResolver i18nResolver;
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)true);

    protected AbstractReportCreator(I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        this.i18nResolver = i18nResolver;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    protected String getPeriodString(TimePeriod timePeriod) {
        return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.period", new Serializable[]{Integer.valueOf(timePeriod.getInterval()), this.i18nResolver.getText(timePeriod.getTimeUnit().getLocalizationKey())});
    }

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }
}

