/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.User;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@EntityType(value="CONFIGURATION")
public class StatisticsData
extends AbstractPluginEntity {
    public static final String TYPE = "CONFLUENCE_STATISTICS";
    public static final String SPACE_NAME = "spaceName";
    private String spaceKey;
    private String title;
    private String urlPath;
    private ContentType contentType;
    private long contentId;
    private long createTimestamp;
    private int viewCount;
    private long viewTimestamp;
    private int editCount;
    private long editTimestamp;
    private int commentCount;
    private long commentTimestamp;
    private int likeCount;
    private long likeTimestamp;
    private User author;
    private Map<String, Object> additionalInfo = new HashMap<String, Object>();
    private UserStatistics userStatistics = new UserStatistics();

    public StatisticsData(String spaceKey, ContentType contentType, long contentId) {
        this.spaceKey = spaceKey;
        this.contentType = contentType;
        this.contentId = contentId;
    }

    public StatisticsData(ContentType contentType, long contentId) {
        this.contentType = contentType;
        this.contentId = contentId;
    }

    public static String getKey(ContentType contentType, long contentId) {
        return contentType + "_" + contentId;
    }

    public String getTag() {
        return StringUtils.isBlank((CharSequence)this.spaceKey) ? this.getKey() : this.spaceKey;
    }

    public String getKey() {
        return StatisticsData.getKey(this.contentType, this.contentId);
    }

    @Generated
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getUrlPath() {
        return this.urlPath;
    }

    @Generated
    public ContentType getContentType() {
        return this.contentType;
    }

    @Generated
    public long getContentId() {
        return this.contentId;
    }

    @Generated
    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public int getViewCount() {
        return this.viewCount;
    }

    @Generated
    public long getViewTimestamp() {
        return this.viewTimestamp;
    }

    @Generated
    public int getEditCount() {
        return this.editCount;
    }

    @Generated
    public long getEditTimestamp() {
        return this.editTimestamp;
    }

    @Generated
    public int getCommentCount() {
        return this.commentCount;
    }

    @Generated
    public long getCommentTimestamp() {
        return this.commentTimestamp;
    }

    @Generated
    public int getLikeCount() {
        return this.likeCount;
    }

    @Generated
    public long getLikeTimestamp() {
        return this.likeTimestamp;
    }

    @Generated
    public User getAuthor() {
        return this.author;
    }

    @Generated
    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public UserStatistics getUserStatistics() {
        return this.userStatistics;
    }

    @Generated
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    @Generated
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    @Generated
    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    @Generated
    public void setViewCount(int viewCount) {
        this.viewCount = viewCount;
    }

    @Generated
    public void setViewTimestamp(long viewTimestamp) {
        this.viewTimestamp = viewTimestamp;
    }

    @Generated
    public void setEditCount(int editCount) {
        this.editCount = editCount;
    }

    @Generated
    public void setEditTimestamp(long editTimestamp) {
        this.editTimestamp = editTimestamp;
    }

    @Generated
    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    @Generated
    public void setCommentTimestamp(long commentTimestamp) {
        this.commentTimestamp = commentTimestamp;
    }

    @Generated
    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    @Generated
    public void setLikeTimestamp(long likeTimestamp) {
        this.likeTimestamp = likeTimestamp;
    }

    @Generated
    public void setAuthor(User author) {
        this.author = author;
    }

    @Generated
    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public void setUserStatistics(UserStatistics userStatistics) {
        this.userStatistics = userStatistics;
    }

    @Generated
    public String toString() {
        return "StatisticsData(super=" + super.toString() + ", spaceKey=" + this.spaceKey + ", title=" + this.title + ", urlPath=" + this.urlPath + ", contentType=" + this.contentType + ", contentId=" + this.contentId + ", createTimestamp=" + this.createTimestamp + ", viewCount=" + this.viewCount + ", viewTimestamp=" + this.viewTimestamp + ", editCount=" + this.editCount + ", editTimestamp=" + this.editTimestamp + ", commentCount=" + this.commentCount + ", commentTimestamp=" + this.commentTimestamp + ", likeCount=" + this.likeCount + ", likeTimestamp=" + this.likeTimestamp + ", author=" + this.author + ", additionalInfo=" + this.additionalInfo + ", userStatistics=" + this.userStatistics + ")";
    }

    @Generated
    public StatisticsData() {
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserStatistics {
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> viewers = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> commentators = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> likers = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> editors = new HashMap<User, Integer>();

        @Generated
        public Map<User, Integer> getViewers() {
            return this.viewers;
        }

        @Generated
        public Map<User, Integer> getCommentators() {
            return this.commentators;
        }

        @Generated
        public Map<User, Integer> getLikers() {
            return this.likers;
        }

        @Generated
        public Map<User, Integer> getEditors() {
            return this.editors;
        }

        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        @Generated
        public void setViewers(Map<User, Integer> viewers) {
            this.viewers = viewers;
        }

        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        @Generated
        public void setCommentators(Map<User, Integer> commentators) {
            this.commentators = commentators;
        }

        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        @Generated
        public void setLikers(Map<User, Integer> likers) {
            this.likers = likers;
        }

        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        @Generated
        public void setEditors(Map<User, Integer> editors) {
            this.editors = editors;
        }

        @Generated
        public String toString() {
            return "StatisticsData.UserStatistics(viewers=" + this.viewers + ", commentators=" + this.commentators + ", likers=" + this.likers + ", editors=" + this.editors + ")";
        }

        @Generated
        public UserStatistics() {
        }
    }

    public static enum ContentType {
        PAGE(com.atlassian.confluence.api.model.content.ContentType.PAGE),
        BLOG_POST(com.atlassian.confluence.api.model.content.ContentType.BLOG_POST);

        private final com.atlassian.confluence.api.model.content.ContentType type;

        private ContentType(com.atlassian.confluence.api.model.content.ContentType type) {
            this.type = type;
        }

        public static ContentType fromConfluenceType(com.atlassian.confluence.api.model.content.ContentType type) {
            for (ContentType contentType : ContentType.values()) {
                if (!contentType.getType().getType().equals(type.getType())) continue;
                return contentType;
            }
            return null;
        }

        @Generated
        public com.atlassian.confluence.api.model.content.ContentType getType() {
            return this.type;
        }
    }
}

