/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.moveworkforward.component.TenantIdProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ConfluenceSettingsManager;
import com.moveworkforward.statistics.ao.repository.StatisticsEntityRepository;
import com.moveworkforward.statistics.service.AbstractStatisticsService;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfluenceStatisticsService
extends AbstractStatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceStatisticsService.class);
    private final ConfluenceSettingsManager settingsManager;

    @Autowired
    public ConfluenceStatisticsService(StatisticsEntityRepository statisticsEntityRepository, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, PluginLicenseManager pluginLicenseManager, TenantIdProvider tenantIdProvider, ConfluenceSettingsManager settingsManager) {
        super(statisticsEntityRepository, pluginAccessor, applicationProperties, pluginLicenseManager, tenantIdProvider);
        this.settingsManager = settingsManager;
    }

    protected boolean isCollectStatistics() {
        return this.settingsManager.getGlobalSettings().isAnalyticsEnabled();
    }

    protected boolean isSendStatistics() {
        return this.settingsManager.getGlobalSettings().isSendStatistics();
    }

    protected <T> List<T> getAllEntities(Class<T> clazz) {
        return this.settingsManager.getConfigurations(clazz);
    }

    protected String[] getPackagesToScan() {
        return new String[]{"com.moveworkforward.confluence.microsoftteams.notifier.model"};
    }

    protected String getRuleType(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        String value = super.getRuleType(obj);
        if (StringUtils.isBlank((CharSequence)value) || "GLOBAL".equals(value) || "f94a2448-696d-4d81-ae30-4e2054daf97f".equalsIgnoreCase(value) || "05f11044-da77-41a8-ac66-a9388ffd0925".equalsIgnoreCase(value)) {
            return "GLOBAL";
        }
        return "SPACE";
    }

    protected String getHostApp() {
        return "confluence";
    }

    protected String getPluginKey() {
        return "confluence-microsoft-teams-connector";
    }
}

