/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsAlertDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsReminderAlertConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsReminderAlertCreator
extends AbstractReportCreator<StatisticsReminderAlertConfiguration, StatisticsAlertDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsReminderAlertCreator.class);

    @Autowired
    public StatisticsReminderAlertCreator(@ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String createPayload(StatisticsReminderAlertConfiguration configuration, StatisticsAlertDataHolder payloadHolder) {
        StatisticsReminderAlertConfiguration.Condition condition = configuration.getCondition();
        int threshold = configuration.getThreshold();
        String baseUrl = this.getBaseUrl();
        StatisticsReminderAlertConfiguration.Activity activity = configuration.getActivity();
        List<StatisticsAlertDataHolder.AlertData> alertData = payloadHolder.getData();
        String subTitle = this.getSubTitle(activity, condition, threshold);
        String sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.page.blogpost");
        String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
        String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
        MessageData messageData = new MessageData(configuration.getName(), subTitle, null);
        ArrayList items = new ArrayList();
        alertData.forEach(a -> items.add(TeamsPayloadUtils.makeMicrosoftTeamsLink((String)(a.getSourceEntity().getTitle() + " - " + a.getCount()), (String)(baseUrl + a.getSourceEntity().getUrlPath()))));
        messageData.getItems().add(new MessageData.Item("items", sectionTitle, showText, hideText, items));
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        String payload = this.objectMapper.writeValueAsString((Object)message);
        log.debug("Statistics Reminder Alert payload: {}", (Object)payload);
        return payload;
    }

    private String getSubTitle(StatisticsReminderAlertConfiguration.Activity activity, StatisticsReminderAlertConfiguration.Condition condition, int threshold) {
        String not = StatisticsReminderAlertConfiguration.Condition.NOT_DONE.equals((Object)condition) ? " " + this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.not") : "";
        switch (activity) {
            case LIKE: {
                return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.liked", new Serializable[]{not, Integer.valueOf(threshold)});
            }
            case EDIT: {
                return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.edited", new Serializable[]{not, Integer.valueOf(threshold)});
            }
            case COMMENT: {
                return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.commented", new Serializable[]{not, Integer.valueOf(threshold)});
            }
            case VIEW: {
                return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.alerts.viewed", new Serializable[]{not, Integer.valueOf(threshold)});
            }
        }
        return "";
    }
}

