/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CqlUtils {
    private CqlUtils() {
    }

    public static void addNotInCriteria(StringBuilder builder, String name, List<String> values) {
        if (!CollectionUtils.isEmpty(values)) {
            CqlUtils.appendCriteria(builder);
            builder.append(name).append(" not in (").append(CqlUtils.quoteList(values)).append(")");
        }
    }

    public static void addCriteria(StringBuilder builder, String name, List<String> values) {
        CqlUtils.addCriteria(builder, name, values, true);
    }

    public static void addCriteria(StringBuilder builder, String name, List<String> values, boolean quoteList) {
        if (!CollectionUtils.isEmpty(values)) {
            CqlUtils.appendCriteria(builder);
            builder.append(name).append(" (").append(quoteList ? CqlUtils.quoteList(values) : CqlUtils.unquoteList(values)).append(")");
        }
    }

    public static void addInCriteria(StringBuilder builder, String name, List<String> values, boolean quoteList) {
        if (!CollectionUtils.isEmpty(values)) {
            CqlUtils.appendCriteria(builder);
            builder.append(name).append(" in (").append(quoteList ? CqlUtils.quoteList(values) : CqlUtils.unquoteList(values)).append(")");
        }
    }

    public static void addEqCriteria(StringBuilder builder, String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            CqlUtils.appendCriteria(builder);
            builder.append(name).append(" = ").append(CqlUtils.quoteValue(value));
        }
    }

    public static void appendCriteria(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(" and ");
        }
    }

    public static String unquoteList(Collection<String> values) {
        return String.join((CharSequence)",", values);
    }

    public static String quoteList(Collection<String> values) {
        return values.stream().map(s -> {
            Object value = s;
            if (!((String)value).startsWith("\"")) {
                value = "\"" + (String)value;
            }
            if (!((String)value).endsWith("\"")) {
                value = (String)value + "\"";
            }
            return value;
        }).collect(Collectors.joining(","));
    }

    public static String quoteValue(String value) {
        if (!((String)value).startsWith("\"")) {
            value = "\"" + (String)value;
        }
        if (!((String)value).endsWith("\"")) {
            value = (String)value + "\"";
        }
        return value;
    }
}

