/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.ao.ScheduledPluginRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel;
import com.moveworkforward.confluence.microsoftteams.notifier.model.SourceEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TaskReminderReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.model.AbstractScheduledReportConfiguration;
import com.moveworkforward.model.Delivery;
import com.moveworkforward.service.CallBackReportService;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.service.ReportService;
import com.moveworkforward.util.DayTimeUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskReminderReportConfigurationService
extends AbstractReportConfigurationService<TaskReminderReportConfiguration>
implements CallBackReportService,
ReportService<TaskReminderReportConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskReminderReportConfigurationService.class);

    @Inject
    public TaskReminderReportConfigurationService(ScheduledPluginRepository<TaskReminderReportConfiguration> repository, List<OperationListener> operationListeners, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor) {
        super(repository, operationListeners, validationHelper, userAccessor);
    }

    @Override
    public List<String> getSpaceKeys(TaskReminderReportConfiguration configuration) {
        List<String> spaceKeys = configuration.getSources().stream().map(SourceEntity::getSpaceKey).collect(Collectors.toList());
        if (ConfigurationLevel.SPACE.equals((Object)configuration.getLevel()) && !spaceKeys.contains(configuration.getSpaceKey())) {
            spaceKeys.add(configuration.getSpaceKey());
        } else if (ConfigurationLevel.GLOBAL.equals((Object)configuration.getLevel()) && !spaceKeys.contains("05f11044-da77-41a8-ac66-a9388ffd0925")) {
            spaceKeys.add("05f11044-da77-41a8-ac66-a9388ffd0925");
        }
        return spaceKeys;
    }

    @Override
    public TaskReminderReportConfiguration save(TaskReminderReportConfiguration entity, boolean checkPermissions) {
        TaskReminderReportConfiguration configuration = super.save(entity, checkPermissions);
        this.onSave(configuration);
        return configuration;
    }

    @Override
    public void validate(TaskReminderReportConfiguration configuration) {
        Delivery delivery;
        super.validate(configuration);
        Objects.requireNonNull(configuration.getDelivery(), "Delivery is null");
        if (configuration.getOwner() == null || StringUtils.isBlank((CharSequence)configuration.getOwner().getUserKey())) {
            configuration.setOwner(this.validationHelper.getCurrentUser());
        }
        if ((delivery = configuration.getDelivery()).getDay() <= 0 && AbstractScheduledReportConfiguration.DeliveryFrequency.WEEKLY.equals((Object)delivery.getFrequency())) {
            throw new RuntimeException("Day is not specified for WEEKLY report");
        }
        this.checkLevels(configuration.getSources(), true, configuration.getLevel(), configuration.getTag());
        this.checkLevels(configuration.getIgnoredSources(), false, configuration.getLevel(), configuration.getTag());
        this.doEnhancement(configuration);
    }

    private void checkLevels(List<SourceEntity> sources, boolean allowAllSpaces, ConfigurationLevel level, String tag) {
        sources.forEach(s -> {
            if ((ConfigurationLevel.SPACE.equals((Object)level) || !allowAllSpaces) && "05f11044-da77-41a8-ac66-a9388ffd0925".equalsIgnoreCase(s.getSpaceKey())) {
                throw new RuntimeException("Global level is not allowed");
            }
            if (ConfigurationLevel.SPACE.equals((Object)level) && !tag.equals(s.getSpaceKey())) {
                throw new RuntimeException("Configuration is for space level '" + tag + "' but contains another space as a source: " + s.getSpaceKey());
            }
        });
    }

    @Override
    public List<TaskReminderReportConfiguration> getConfigurationsForDate(Date date, boolean skipDateValidation) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int calendarDay = calendar.get(7);
        int hour = calendar.get(11);
        int minute = DayTimeUtil.adjustMinute((int)calendar.get(12));
        DayTimeUtil.Day day = DayTimeUtil.getDay((int)calendarDay);
        log.debug("{} day, {} hour, {} minute", new Object[]{day, hour, minute});
        List configurations = skipDateValidation ? this.getAll(false) : ((ScheduledPluginRepository)this.pluginRepository).getByDateAndTime(day.getNumber(), hour, minute);
        log.debug("Count of reminder configurations: {}", (Object)configurations.size());
        return configurations;
    }

    protected void doEnhancement(TaskReminderReportConfiguration configuration) {
        configuration.setOwner(this.enrichUser(configuration.getOwner()));
        this.enrichUsers(configuration.getAssigneesUsers());
        this.enrichUsers(configuration.getCompleteUsers());
        this.enrichUsers(configuration.getCreatorsUsers());
    }

    public String getType() {
        return "task-reminder-report";
    }

    public Class<TaskReminderReportConfiguration> getConfigurationClass() {
        return TaskReminderReportConfiguration.class;
    }
}

