/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.ChannelConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.NotificationRuleConfiguration;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.statistics.annotations.StatisticsEntity;
import com.moveworkforward.statistics.annotations.StatisticsField;
import com.moveworkforward.statistics.annotations.StatisticsRuleLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"destination", "sourceKeys"})
@EntityType(value="CONFIGURATION")
@StatisticsEntity(value="CONFIGURATION")
public class Configuration
extends AbstractPluginEntity
implements SourcePluginEntity,
PluginEntity,
DestinationHolder<BaseDestination> {
    public static final String TYPE = "CONFIGURATION";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String NO_SPACES = "f94a2448-696d-4d81-ae30-4e2054daf97f";
    public static final String NOT_SET = "NOT_SET";
    @JsonProperty(value="key")
    private String key;
    @StatisticsRuleLevel
    private String spaceKey;
    private List<BaseDestination> destinations = new ArrayList<BaseDestination>();
    @StatisticsField
    private List<Source> events = new ArrayList<Source>();
    @StatisticsField
    private String pathFilter;
    private String name;
    @JsonProperty(value="configuration")
    private NotificationRuleConfiguration configuration = new NotificationRuleConfiguration();
    @StatisticsField
    private boolean minimalContent;
    @StatisticsField
    private boolean expandedCard;
    @StatisticsField
    private boolean viewActionsButton = true;

    public Configuration() {
        this.destinations.add(new BaseDestination());
    }

    public Configuration(ChannelConfiguration entity) {
        this.key = entity.getId();
        this.spaceKey = entity.getSpaceKey();
        BaseDestination destination = new BaseDestination();
        destination.setUrl(entity.getWebhookUrl());
        this.getDestinations().add(destination);
        this.pathFilter = entity.getPathFilter();
        this.setEnabled(entity.getEnabled() == null || entity.getEnabled() != false);
        this.name = entity.getName();
        if (StringUtils.isNotBlank((CharSequence)entity.getEvents())) {
            for (String source : entity.getEvents().split(",")) {
                this.events.add(Source.valueOf(source));
            }
        }
    }

    public String getKey() {
        if (StringUtils.isBlank((CharSequence)this.key)) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public String getTag() {
        return NO_SPACES.equalsIgnoreCase(this.getSpaceKey()) ? ALL_SPACES : this.getSpaceKey();
    }

    public String getSpaceKey() {
        if (StringUtils.isBlank((CharSequence)this.spaceKey)) {
            this.spaceKey = ALL_SPACES;
        }
        return this.spaceKey;
    }

    public BaseDestination getDestination() {
        return this.destinations.get(0);
    }

    public List<String> getSourceKeys() {
        return Collections.singletonList(this.getSpaceKey());
    }

    public void setSourceKeys(List<String> sourceKeys) {
        this.spaceKey = CollectionUtils.isEmpty(sourceKeys) ? ALL_SPACES : sourceKeys.get(0);
    }

    @Generated
    public List<BaseDestination> getDestinations() {
        return this.destinations;
    }

    @Generated
    public List<Source> getEvents() {
        return this.events;
    }

    @Generated
    public String getPathFilter() {
        return this.pathFilter;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public NotificationRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public boolean isMinimalContent() {
        return this.minimalContent;
    }

    @Generated
    public boolean isExpandedCard() {
        return this.expandedCard;
    }

    @Generated
    public boolean isViewActionsButton() {
        return this.viewActionsButton;
    }

    @JsonProperty(value="key")
    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Generated
    public void setDestinations(List<BaseDestination> destinations) {
        this.destinations = destinations;
    }

    @Generated
    public void setEvents(List<Source> events) {
        this.events = events;
    }

    @Generated
    public void setPathFilter(String pathFilter) {
        this.pathFilter = pathFilter;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="configuration")
    @Generated
    public void setConfiguration(NotificationRuleConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setMinimalContent(boolean minimalContent) {
        this.minimalContent = minimalContent;
    }

    @Generated
    public void setExpandedCard(boolean expandedCard) {
        this.expandedCard = expandedCard;
    }

    @Generated
    public void setViewActionsButton(boolean viewActionsButton) {
        this.viewActionsButton = viewActionsButton;
    }

    @Generated
    public String toString() {
        return "Configuration(super=" + super.toString() + ", key=" + this.key + ", spaceKey=" + this.spaceKey + ", destinations=" + this.destinations + ", events=" + this.events + ", pathFilter=" + this.pathFilter + ", name=" + this.name + ", configuration=" + this.configuration + ", minimalContent=" + this.minimalContent + ", expandedCard=" + this.expandedCard + ", viewActionsButton=" + this.viewActionsButton + ")";
    }
}

