/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.ao.entity.ReportEntity;
import com.moveworkforward.ao.entity.ScheduledEntity;
import com.moveworkforward.component.GlobalSettingsManager;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceSettingsManager
implements GlobalSettingsManager<ConfluenceGlobalSettings> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSettingsManager.class);
    private final PluginSettingEntityRepository pluginSettingEntityRepository;
    private final ReportEntityRepository reportEntityRepository;

    @Autowired
    public ConfluenceSettingsManager(@ComponentImport ActiveObjects activeObjects, @ComponentImport TransactionTemplate transactionTemplate) {
        this.pluginSettingEntityRepository = new PluginSettingEntityRepository(activeObjects, transactionTemplate);
        this.reportEntityRepository = new ReportEntityRepository(activeObjects, transactionTemplate);
    }

    public ConfluenceGlobalSettings getGlobalSettings() {
        return this.pluginSettingEntityRepository.getAll(ConfluenceGlobalSettings.class).stream().findFirst().orElse(new ConfluenceGlobalSettings());
    }

    public <T> List<T> getConfigurations(Class<T> clazz) {
        if (ScheduledEntity.class.isAssignableFrom(clazz)) {
            return this.reportEntityRepository.getAll(clazz);
        }
        if (PluginEntity.class.isAssignableFrom(clazz)) {
            return this.pluginSettingEntityRepository.getAll(clazz);
        }
        log.warn("Unsupported class: {}", clazz);
        return Collections.emptyList();
    }

    private static class PluginSettingEntityRepository
    extends AbstractPluginRepository<PluginSettingEntity> {
        public PluginSettingEntityRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
            super(activeObjects, transactionTemplate);
        }
    }

    private static class ReportEntityRepository
    extends AbstractPluginRepository<ReportEntity> {
        public ReportEntityRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
            super(activeObjects, transactionTemplate);
        }
    }
}

