/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.LicenseManager;
import java.util.List;
import javax.inject.Inject;

public class ViewConfigurationSpaceAction
extends SpaceAdminAction {
    private final PermissionManager permissionManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LicenseManager licenseManager;

    @Inject
    public ViewConfigurationSpaceAction(@ComponentImport PermissionManager permissionManager, LicenseManager licenseManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.space);
    }

    public boolean isLicenseValid() {
        return this.licenseManager.isLicensed();
    }

    public List<LicenseManager.LicenseNotification> getLicenseNotifications() {
        return this.licenseManager.getLicenseNotifications();
    }

    public String getHostBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String execute() {
        return "success";
    }
}

