/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TopItemsReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.TopItemsReportConfigurationRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.service.OperationListener;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TopItemsReportConfigurationService
extends AbstractStatisticsReportConfigurationService<TopItemsReportConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopItemsReportConfigurationService.class);

    @Autowired
    public TopItemsReportConfigurationService(TopItemsReportConfigurationRepository repository, List<OperationListener> operationListeners, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager) {
        super(repository, operationListeners, validationHelper, userAccessor, pageManager, spaceManager);
    }

    @Override
    public void validate(TopItemsReportConfiguration configuration) {
        super.validate(configuration);
        if (configuration.getContentAmount() <= 0 || configuration.getContentAmount() > 10) {
            throw new IllegalArgumentException("Content amount must be greater than 0 and less or equal to 10");
        }
        if (CollectionUtils.isEmpty(configuration.getSectionTypes())) {
            throw new IllegalArgumentException("At least one section must be defined: " + Stream.of(TopItemsReportConfiguration.SectionType.values()).map(Enum::toString).collect(Collectors.joining(", ")));
        }
    }

    @Override
    public boolean shouldProcess(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        String spaceKey = content instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)content).getSpaceKey() : null;
        StatisticsData.ContentType contentType = StatisticService.getContentType(content);
        long contentId = content.getId();
        List configurations = this.pluginRepository.getAll();
        boolean result = configurations.stream().anyMatch(c -> !CollectionUtils.isEmpty((Collection)c.getSources()) && c.getSources().stream().anyMatch(s -> StringUtils.isNotBlank((CharSequence)s.getSpaceKey()) && s.getSpaceKey().equals(spaceKey)));
        log.debug("Content type: {}, content ID: {}, should process: {}", new Object[]{contentType, contentId, result});
        return result;
    }

    public String getType() {
        return "top-items-report";
    }

    public Class<TopItemsReportConfiguration> getConfigurationClass() {
        return TopItemsReportConfiguration.class;
    }
}

