/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.ConfluenceUser;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.confluence.microsoftteams.notifier.model.AbstractStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.HistoricalStatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.HistoricalStatisticsRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.StatisticsRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.AdminValidationHelper;
import com.moveworkforward.model.User;
import com.moveworkforward.service.impl.AbstractConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticService
extends AbstractConfigurationService<StatisticsData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticService.class);
    private final List<AbstractStatisticsReportConfigurationService<? extends AbstractStatisticReportConfiguration>> statisticsReportServices;
    private final HistoricalStatisticsRepository historicalStatisticsRepository;

    @Autowired
    public StatisticService(StatisticsRepository statisticsRepository, List<AbstractStatisticsReportConfigurationService<? extends AbstractStatisticReportConfiguration>> statisticsReportServices, AdminValidationHelper validationHelper, HistoricalStatisticsRepository historicalStatisticsRepository) {
        super((PluginRepository)statisticsRepository, null, (ValidationHelper)validationHelper);
        this.statisticsReportServices = statisticsReportServices;
        this.historicalStatisticsRepository = historicalStatisticsRepository;
    }

    public static StatisticsData.ContentType getContentType(ContentEntityObject content) {
        StatisticsData.ContentType result = null;
        if (content instanceof BlogPost) {
            result = StatisticsData.ContentType.BLOG_POST;
        } else if (content instanceof Page) {
            result = StatisticsData.ContentType.PAGE;
        }
        log.debug("Content Type: {}", (Object)result);
        return result;
    }

    public static ContentEntityObject getContainerContentEntity(ContentEntityObject content) {
        ContentEntityObject result = null;
        if (content instanceof BlogPost || content instanceof Page) {
            result = content;
        } else if (content instanceof Comment) {
            result = StatisticService.getContainerContentEntity(((Comment)content).getContainer());
        }
        log.debug("Content entity: {}", (Object)result);
        return result;
    }

    public StatisticsData get(StatisticsData.ContentType contentType, Long contentId) {
        if (contentType == null || contentId == null) {
            log.warn("Content Type or Content ID is not set");
            return null;
        }
        return (StatisticsData)this.pluginRepository.getByKey(StatisticsData.getKey(contentType, contentId));
    }

    public void process(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        StatisticsData.ContentType contentType = StatisticService.getContentType(content);
        if (content == null || contentType == null) {
            log.warn("Can't handle content {} of type {}", (Object)statisticsEvent.getContentEvent().getContent().getContentId(), (Object)contentType);
            return;
        }
        long contentId = content.getId();
        String spaceKey = content instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)content).getSpaceKey() : null;
        StatisticsData statisticsData = (StatisticsData)this.pluginRepository.getByKey(StatisticsData.getKey(contentType, contentId));
        if (statisticsData == null && !this.shouldProcess(statisticsEvent)) {
            log.debug("Skip event from statistics");
            return;
        }
        if (statisticsData == null) {
            statisticsData = new StatisticsData(spaceKey, contentType, contentId);
            statisticsData.setTitle(content.getTitle());
            statisticsData.setUrlPath(content.getUrlPath());
            ConfluenceUser user = content.getCreator();
            statisticsData.setCreateTimestamp(content.getCreationDate().getTime());
            statisticsData.setAuthor(new User(user.getKey().getStringValue(), user.getFullName()));
        }
        Map<String, Object> additionalInfo = this.getAdditionalInfo(statisticsEvent);
        statisticsData.setAdditionalInfo(additionalInfo);
        this.processCount(statisticsData, statisticsEvent);
        this.pluginRepository.save((PluginEntity)statisticsData);
    }

    private Map<String, Object> getAdditionalInfo(StatisticsEvent statisticsEvent) {
        HashMap<String, Object> additionalInfo = new HashMap<String, Object>();
        this.statisticsReportServices.stream().forEach(s -> additionalInfo.putAll(s.getAdditionalInfo(statisticsEvent)));
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        String spaceName = content instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)content).getSpace().getName() : null;
        additionalInfo.put("spaceName", spaceName);
        return additionalInfo;
    }

    private void processCount(StatisticsData statisticsData, StatisticsEvent statisticsEvent) {
        StatisticsEvent.EventType eventType = statisticsEvent.getEventType();
        long timestamp = statisticsEvent.getContentEvent().getTimestamp();
        StatisticsData.UserStatistics userStatistics = statisticsData.getUserStatistics();
        User eventUser = this.validationHelper.getCurrentUser();
        switch (eventType) {
            case PAGE_CREATE: 
            case BLOG_POST_CREATE: {
                statisticsData.setCreateTimestamp(timestamp);
                break;
            }
            case PAGE_VIEW: 
            case BLOG_POST_VIEW: {
                statisticsData.setViewCount(statisticsData.getViewCount() + 1);
                statisticsData.setViewTimestamp(timestamp);
                userStatistics.getViewers().compute(eventUser, (user, count) -> count == null ? 1 : count + 1);
                break;
            }
            case PAGE_UPDATE: 
            case BLOG_POST_UPDATE: {
                statisticsData.setEditCount(statisticsData.getEditCount() + 1);
                statisticsData.setEditTimestamp(timestamp);
                userStatistics.getEditors().compute(eventUser, (user, count) -> count == null ? 1 : count + 1);
                break;
            }
            case LIKE_CREATED: {
                statisticsData.setLikeCount(statisticsData.getLikeCount() + 1);
                statisticsData.setLikeTimestamp(timestamp);
                userStatistics.getLikers().compute(eventUser, (user, count) -> count == null ? 1 : count + 1);
                break;
            }
            case LIKE_REMOVED: {
                statisticsData.setLikeCount(Math.max(statisticsData.getLikeCount() - 1, 0));
                statisticsData.setLikeTimestamp(timestamp);
                userStatistics.getLikers().compute(eventUser, (user, count) -> Math.max(0, count == null ? 0 : count - 1));
                break;
            }
            case COMMENT_CREATE: 
            case COMMENT_UPDATE: {
                statisticsData.setCommentCount(statisticsData.getCommentCount() + 1);
                statisticsData.setCommentTimestamp(timestamp);
                userStatistics.getCommentators().compute(eventUser, (user, count) -> count == null ? 1 : count + 1);
                break;
            }
            case COMMENT_REMOVE: {
                statisticsData.setCommentCount(Math.max(statisticsData.getCommentCount() - 1, 0));
                statisticsData.setCommentTimestamp(timestamp);
                userStatistics.getCommentators().compute(eventUser, (user, count) -> Math.max(0, count == null ? 0 : count - 1));
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type: " + (Object)((Object)eventType));
            }
        }
    }

    private boolean shouldProcess(StatisticsEvent statisticsEvent) {
        return this.statisticsReportServices.stream().anyMatch(service -> service.shouldProcess(statisticsEvent));
    }

    protected List<StatisticsData> filter(List<StatisticsData> list) {
        return list;
    }

    protected void validate(StatisticsData statisticsData) {
    }

    protected void hasUserAdminPermissions() {
        if (!this.validationHelper.isGlobalAdmin(this.validationHelper.getCurrentUser())) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }

    public int deleteAll(boolean checkPermissions) {
        this.hasUserAdminPermissions();
        return this.pluginRepository.deleteAll();
    }

    public HistoricalStatisticsData getHistoryByKey(String key) {
        return (HistoricalStatisticsData)this.historicalStatisticsRepository.getByKey(key);
    }

    public List<HistoricalStatisticsData> getHistoryByTag(String tag) {
        return this.historicalStatisticsRepository.getByTag(tag);
    }

    public HistoricalStatisticsData saveHistory(HistoricalStatisticsData historicalStatisticsData) {
        return (HistoricalStatisticsData)this.historicalStatisticsRepository.save((PluginEntity)historicalStatisticsData);
    }
}

