/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.migration;

import com.atlassian.migration.app.tracker.AbstractCloudMigrationListener;
import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.CloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.migration.TeamsCloudMigrationAccessor;
import com.moveworkforward.util.ConnectorUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDataMigrator
implements CloudMigrationListenerV1,
InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDataMigrator.class);
    private final TeamsCloudMigrationAccessor accessor;
    private final List<PluginRepository<?>> pluginRepositories;

    @Autowired
    public PluginDataMigrator(TeamsCloudMigrationAccessor accessor, List<PluginRepository<?>> pluginRepositories) {
        this.accessor = accessor;
        this.pluginRepositories = pluginRepositories;
    }

    public void onRegistrationAccepted() {
        log.info("Teams migration listener is ready to take migrations events");
    }

    public void onStartAppMigration(String transferId, MigrationDetailsV1 migrationDetails) {
        Optional.ofNullable(this.accessor.getCloudMigrationAccessor()).ifPresent(t -> {
            ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();
            this.pluginRepositories.forEach(pluginRepository -> {
                try {
                    OutputStream outputStream = t.getCloudMigrationGateway().createAppData(transferId, pluginRepository.getEntityType());
                    String payload = objectMapper.writeValueAsString((Object)pluginRepository.getAll());
                    outputStream.write(payload.getBytes());
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("Error uploading files to the cloud, type: " + pluginRepository.getEntityType(), (Throwable)e);
                }
            });
        });
    }

    public void onRegistrarRemoved() {
        log.info("Teams listener is no longer active");
    }

    public String getCloudAppKey() {
        return "confluence-microsoft-teams-connector";
    }

    public String getServerAppKey() {
        return "confluence-microsoft-teams-connector";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public void afterPropertiesSet() {
        Optional.ofNullable(this.accessor.getCloudMigrationAccessor()).ifPresent(t -> t.registerListener((AbstractCloudMigrationListener)this));
    }

    public void destroy() {
        Optional.ofNullable(this.accessor.getCloudMigrationAccessor()).ifPresent(t -> t.deregisterListener((AbstractCloudMigrationListener)this));
    }
}

