import React from 'react';
import { TaskTypeValues } from 'src/consts';
import { ReactComponent as ReportTaskReminder } from './reports-selector/task-reminder/logo.svg';
import { ReactComponent as ReportContentStatistic } from './reports-selector/content-statistic/logo.svg';
import { ReactComponent as ReportApplicationUpdate } from './reports-selector/app-updates/logo.svg';

import { ReactComponent as TaskReminder1 } from './reports-selector/task-reminder/slides/task-reminder-get-it-done.svg';
import { ReactComponent as TaskReminder2 } from './reports-selector/task-reminder/slides/task-reminder-quickly-act-on-issues.svg';
import { ReactComponent as TaskReminder3 } from './reports-selector/task-reminder/slides/task-reminder-do-not-miss.svg';

import { ReactComponent as ContentStatistic1 } from './reports-selector/content-statistic/slides/content-statistic-track-project-activity.svg';
import { ReactComponent as ContentStatistic2 } from './reports-selector/content-statistic/slides/content-statistic-save-time.svg';
import { ReactComponent as ContentStatistic3 } from './reports-selector/content-statistic/slides/content-statistic-see-and-optimise.svg';

import { ReactComponent as ApplicationUpdate1 } from './reports-selector/content-statistic/slides/content-statistic-track-project-activity.svg';
import { ReactComponent as ApplicationUpdate2 } from './reports-selector/content-statistic/slides/content-statistic-save-time.svg';
import { ReactComponent as ApplicationUpdate3 } from './reports-selector/content-statistic/slides/content-statistic-see-and-optimise.svg';

export default {
    reports: {
        [TaskTypeValues.TaskReminderConfiguration]: {
            main: <ReportTaskReminder />,
            slides: [
                <TaskReminder1 key="slide-1" />,
                <TaskReminder2 key="slide-2" />,
                <TaskReminder3 key="slide-3" />,
            ]
        },
        [TaskTypeValues.ContentStatistic]: {
            main: <ReportContentStatistic />,
            slides: [
                <ContentStatistic1 key="slide-1" />,
                <ContentStatistic2 key="slide-2" />,
                <ContentStatistic3 key="slide-3" />,
            ]
        },
        [TaskTypeValues.ApplicationsUpdate]: {
            main: <ReportApplicationUpdate />,
            slides: [
                <ApplicationUpdate1 key="slide-1" />,
                <ApplicationUpdate2 key="slide-2" />,
                <ApplicationUpdate3 key="slide-3" />,
            ]
        }
    },
};
