/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.actions;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;

public enum Source {
    PAGE_CREATED("Page created"),
    PAGE_UPDATED("Page updated"),
    PAGE_DELETED("Page deleted"),
    BLOGPOST_CREATED("Blog post created"),
    BLOGPOST_UPDATED("Blog post updated"),
    BLOGPOST_DELETED("Blog post deleted"),
    COMMENT_CREATED("Comment created"),
    COMMENT_UPDATED("Comment updated"),
    CALENDAR_EVENT_CREATED("Calendar event created"),
    CALENDAR_EVENT_UPDATED("Calendar event updated"),
    CALENDAR_EVENT_DELETED("Calendar event deleted"),
    ANSWER_CREATED("Answer created"),
    QUESTION_CREATED("Question created"),
    ATTACHMENT_CREATED("Attachment created"),
    ATTACHMENT_UPDATED("Attachment updated");

    private final String name;

    private Source(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Source getSource(ContentEvent event) throws Exception {
        Source result;
        if (event instanceof PageCreateEvent) {
            result = PAGE_CREATED;
        } else if (event instanceof PageUpdateEvent) {
            result = PAGE_UPDATED;
        } else if (event instanceof PageRemoveEvent || event instanceof PageTrashedEvent) {
            result = PAGE_DELETED;
        } else if (event instanceof BlogPostCreateEvent) {
            result = BLOGPOST_CREATED;
        } else if (event instanceof BlogPostUpdateEvent) {
            result = BLOGPOST_UPDATED;
        } else if (event instanceof BlogPostRemoveEvent || event instanceof BlogPostTrashedEvent) {
            result = BLOGPOST_DELETED;
        } else if (event instanceof CommentCreateEvent) {
            result = COMMENT_CREATED;
        } else if (event instanceof CommentUpdateEvent) {
            result = COMMENT_UPDATED;
        } else if (event instanceof AttachmentCreateEvent) {
            result = ATTACHMENT_CREATED;
        } else if (event instanceof AttachmentUpdateEvent) {
            result = ATTACHMENT_UPDATED;
        } else {
            throw new Exception(event.getClass().toString() + " was not mapped");
        }
        return result;
    }
}

