/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ModelVersion;
import com.moveworkforward.ao.AbstractUpgradeTask;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import java.util.Map;
import lombok.Generated;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask5
extends AbstractUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask5.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"5");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{PluginSettingEntity.class});
        PluginSettingEntity[] entities = (PluginSettingEntity[])activeObjects.find(PluginSettingEntity.class, Query.select().where("TYPE = ?", new Object[]{"GLOBAL_SETTINGS"}));
        if (entities == null) {
            log.info("Nothing to migrate for version 5");
            return;
        }
        for (PluginSettingEntity entity : entities) {
            try {
                log.info("{} global settings for migration", (Object)entity.getContent());
                Map map = (Map)this.objectMapper.readValue(entity.getContent(), Map.class);
                map.put("analyticsEnabled", true);
                map.put("sendStatistics", true);
                entity.setContent(this.objectMapper.writeValueAsString((Object)map));
                entity.save();
            }
            catch (Exception e) {
                log.error("Can't migrate global settings " + entity.getContent(), (Throwable)e);
            }
        }
    }
}

