/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsAlertDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsReminderAlertConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsSourceEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.StatisticsReminderAlertCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticsReminderReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsReminderAlertExecutor
extends AbstractReportExecutor<StatisticsReminderAlertConfiguration, StatisticsAlertDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsReminderAlertExecutor.class);
    private final StatisticService statisticService;

    @Autowired
    public StatisticsReminderAlertExecutor(StatisticsReminderReportConfigurationService configurationService, UrlConfigurationServiceImpl urlConfigurationService, StatisticsReminderAlertCreator reportCreator, StatisticService statisticService) {
        super(configurationService, urlConfigurationService, reportCreator);
        this.statisticService = statisticService;
    }

    @Override
    protected void postExecute(Map<StatisticsReminderAlertConfiguration, StatisticsAlertDataHolder> dataPerConfiguration, List<StatisticsReminderAlertConfiguration> configurations, List<StatisticsReminderAlertConfiguration> errorConfigurations) {
        this.reScheduleConfigurations(errorConfigurations);
        dataPerConfiguration.forEach((configuration, data) -> {
            if (errorConfigurations.contains(configuration)) {
                log.debug("Configuration has been re-scheduler due to the errors: {}", (Object)configuration);
                return;
            }
            StatisticsReminderAlertConfiguration.ActionOnAlert actionOnAlert = configuration.getActionOnAlert();
            StatisticsReminderAlertConfiguration.Condition condition = configuration.getCondition();
            if (StatisticsReminderAlertConfiguration.Condition.NOT_DONE.equals((Object)condition)) {
                if (data.isEmpty()) {
                    this.disableOrDelete((StatisticsReminderAlertConfiguration)((Object)configuration), actionOnAlert);
                } else {
                    this.performActionOnAlert((StatisticsReminderAlertConfiguration)((Object)configuration), actionOnAlert);
                }
            } else {
                this.performActionOnAlert((StatisticsReminderAlertConfiguration)((Object)configuration), actionOnAlert);
            }
        });
    }

    private void performActionOnAlert(StatisticsReminderAlertConfiguration configuration, StatisticsReminderAlertConfiguration.ActionOnAlert actionOnAlert) {
        if (StatisticsReminderAlertConfiguration.ActionOnAlert.REPEAT.equals((Object)actionOnAlert)) {
            configuration.getDelivery().setDate(null);
            this.configurationService.save(configuration, false);
        } else {
            this.disableOrDelete(configuration, actionOnAlert);
        }
    }

    private void disableOrDelete(StatisticsReminderAlertConfiguration configuration, StatisticsReminderAlertConfiguration.ActionOnAlert actionOnAlert) {
        if (StatisticsReminderAlertConfiguration.ActionOnAlert.DELETE.equals((Object)actionOnAlert)) {
            this.configurationService.delete(configuration.getId(), false);
        } else {
            configuration.setEnabled(false);
            this.configurationService.save(configuration, false);
        }
    }

    @Override
    protected StatisticsAlertDataHolder getPayloadDataByConfiguration(StatisticsReminderAlertConfiguration configuration, Date date) {
        StatisticsReminderAlertConfiguration.Condition condition = configuration.getCondition();
        int threshold = configuration.getThreshold();
        StatisticsReminderAlertConfiguration.Activity activity = configuration.getActivity();
        Set statisticsData = configuration.getSources().stream().map(s -> this.getStatisticsData(s.getContentType(), s.getContentId())).collect(Collectors.toSet());
        List<StatisticsAlertDataHolder.AlertData> alertData = configuration.getSources().stream().map(s -> this.getAlertData((StatisticsSourceEntity)s, condition, threshold, activity, statisticsData)).filter(Objects::nonNull).collect(Collectors.toList());
        log.debug("Statistics found {} for configuration {}", (Object)alertData.size(), (Object)configuration);
        return new StatisticsAlertDataHolder(alertData);
    }

    private StatisticsData getStatisticsData(StatisticsData.ContentType contentType, Long contentId) {
        StatisticsData statisticsData = this.statisticService.get(contentType, contentId);
        if (statisticsData == null) {
            log.debug("Nod statistics are found for {}/{}", (Object)contentType, (Object)contentId);
            statisticsData = new StatisticsData(contentType, contentId);
        }
        return statisticsData;
    }

    private StatisticsAlertDataHolder.AlertData getAlertData(StatisticsSourceEntity sourceEntity, StatisticsReminderAlertConfiguration.Condition condition, int threshold, StatisticsReminderAlertConfiguration.Activity activity, Set<StatisticsData> data) {
        StatisticsData statisticsData = data.stream().filter(d -> sourceEntity.getContentType().equals((Object)d.getContentType()) && sourceEntity.getContentId().longValue() == d.getContentId()).findFirst().orElse(null);
        int count = 0;
        if (statisticsData == null) {
            log.debug("Statistics is not found for {}", (Object)sourceEntity);
        } else {
            switch (activity) {
                case EDIT: {
                    count = statisticsData.getEditCount();
                    break;
                }
                case COMMENT: {
                    count = statisticsData.getCommentCount();
                    break;
                }
                case LIKE: {
                    count = statisticsData.getLikeCount();
                    break;
                }
                case VIEW: {
                    count = statisticsData.getViewCount();
                    break;
                }
                default: {
                    throw new RuntimeException("Acitvity is not found: " + (Object)((Object)activity));
                }
            }
        }
        if (StatisticsReminderAlertConfiguration.Condition.NOT_DONE.equals((Object)condition)) {
            return count < threshold ? new StatisticsAlertDataHolder.AlertData(sourceEntity, count) : null;
        }
        return count >= threshold ? new StatisticsAlertDataHolder.AlertData(sourceEntity, count) : null;
    }
}

