/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.DecoratorSpace;
import com.moveworkforward.confluence.microsoftteams.notifier.model.SourceEntity;
import com.moveworkforward.model.AbstractConfiguration;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.SourcePluginEntity;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceUtils.class);
    private final SpaceManager spaceManager;
    private final List<PluginRepository<? extends PluginEntity>> repositories;

    public SpaceUtils(SpaceManager spaceManager, List<PluginRepository<? extends PluginEntity>> repositories) {
        this.spaceManager = spaceManager;
        this.repositories = repositories;
    }

    public void fillUpSpaces(Map<String, DecoratorSpace> target) {
        this.repositories.forEach(repository -> repository.getAll().forEach(pluginEntity -> {
            if (pluginEntity instanceof LevelPluginEntity) {
                String spaceKey = ((LevelPluginEntity)pluginEntity).getSourceKey();
                this.fillUpSpace(spaceKey, target);
            }
            if (pluginEntity instanceof SourcePluginEntity) {
                List spaceKeys = ((SourcePluginEntity)pluginEntity).getSourceKeys();
                this.fillUpSpaces(spaceKeys, target);
            }
            if (pluginEntity instanceof AbstractConfiguration) {
                this.fillUpSpaces(((AbstractConfiguration)pluginEntity).getSources(), target);
                this.fillUpSpaces(((AbstractConfiguration)pluginEntity).getIgnoredSources(), target);
            }
        }));
    }

    public void fillUpSpaces(List<?> spaceSources, Map<String, DecoratorSpace> target) {
        if (!CollectionUtils.isEmpty(spaceSources)) {
            spaceSources.forEach(spaceSource -> {
                if (spaceSource instanceof SourceEntity) {
                    this.fillUpSpace(((SourceEntity)spaceSource).getSpaceKey(), target);
                } else if (spaceSource instanceof String) {
                    this.fillUpSpace((String)spaceSource, target);
                }
            });
        }
    }

    public void fillUpSpace(String spaceKey, Map<String, DecoratorSpace> target) {
        if (StringUtils.isBlank((CharSequence)spaceKey) || "05f11044-da77-41a8-ac66-a9388ffd0925".equalsIgnoreCase(spaceKey) || "f94a2448-696d-4d81-ae30-4e2054daf97f".equalsIgnoreCase(spaceKey) || "NOT_SET".equalsIgnoreCase(spaceKey) || target.containsKey(spaceKey)) {
            return;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.debug("Space is not found by key: {}", (Object)spaceKey);
            return;
        }
        target.put(spaceKey, new DecoratorSpace(space));
    }
}

