/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.MeResponse;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UserOnboarding;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UserOnboardingItem;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UserSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.report.taskremind.InlineTaskServiceHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UserSettingsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="me")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public final class MeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeController.class);
    private final UserSettingsService userSettingsService;
    private final PluginAccessor pluginAccessor;
    private final InlineTaskServiceHolder inlineTaskServiceHolder;
    private final GlobalSettingsService globalSettingsService;

    @Inject
    public MeController(UserSettingsService userSettingsService, @ComponentImport PluginAccessor pluginAccessor, InlineTaskServiceHolder inlineTaskServiceHolder, GlobalSettingsService globalSettingsService) {
        this.userSettingsService = userSettingsService;
        this.pluginAccessor = pluginAccessor;
        this.inlineTaskServiceHolder = inlineTaskServiceHolder;
        this.globalSettingsService = globalSettingsService;
    }

    @GET
    public MeResponse get() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String userKey = confluenceUser.getKey().getStringValue();
        MeResponse result = new MeResponse();
        result.setUserKey(userKey);
        result.setUsername(confluenceUser.getFullName());
        UserSettings userSettings = this.userSettingsService.getByKey(userKey);
        boolean isCompleted = false;
        List<UserOnboardingItem> items = new ArrayList<UserOnboardingItem>();
        if (userSettings != null) {
            UserOnboarding onboarding = userSettings.getOnboarding();
            isCompleted = onboarding.isCompleted();
            items = onboarding.getItems();
        }
        if (items.size() == 0) {
            items.add(new UserOnboardingItem(false, "Check the documentation. Can be found <a href=\"https://help.moveworkforward.com/MTCC/microsoft-teams-confluence-connector-server-and-da\" target=\"_blank\" class=\"text-link\">here</a>", "1"));
            items.add(new UserOnboardingItem(false, "Setup the first rule", "2"));
            items.add(new UserOnboardingItem(false, "Help a colleague to setup the first rule", "3"));
        }
        result.getOnboarding().setItems(items);
        result.getOnboarding().setCompleted(isCompleted);
        Map<String, String> values = result.getSettings().getValues();
        try {
            values.put("confluence.questions.support", Boolean.toString(this.pluginAccessor.isPluginModuleEnabled(QuestionType.QUESTION.getPluginModuleKey())));
        }
        catch (Throwable e) {
            log.debug("Could not test Questions plugin", e);
        }
        values.put("inline.task.enabled", Boolean.toString(this.inlineTaskServiceHolder.getInlineTaskService() != null));
        values.putAll(this.globalSettingsService.getServerProperties());
        return result;
    }

    @POST
    @Path(value="/onboarding")
    public UserOnboarding saveOnboarding(UserOnboarding onboarding) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        String userKey = confluenceUser.getKey().getStringValue();
        UserSettings userSettings = this.userSettingsService.getByKey(userKey);
        if (userSettings == null) {
            userSettings = new UserSettings();
            userSettings.setKey(userKey);
            userSettings.setTag(userKey);
        }
        userSettings.setOnboarding(onboarding);
        userSettings = this.userSettingsService.save(userSettings);
        return userSettings.getOnboarding();
    }
}

