/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractConfluenceConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.service.OperationListener;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationServiceImpl
extends AbstractConfluenceConfigurationService<Configuration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    @Inject
    public ConfigurationServiceImpl(PluginRepository<Configuration> pluginRepository, List<OperationListener> operationListeners, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor) {
        super(pluginRepository, operationListeners, validationHelper, userAccessor);
    }

    protected void validate(Configuration configuration) {
        super.validate((PluginEntity)configuration);
        if (configuration.getId() != null && "NOT_SET".equals(configuration.getKey())) {
            Configuration existingConfiguration = (Configuration)this.pluginRepository.get(configuration.getId().intValue());
            if (existingConfiguration != null) {
                log.debug("Updating configuration with key {}", (Object)configuration.getKey());
                configuration.setKey(existingConfiguration.getKey());
            } else {
                log.debug("Saving new configuration with key {}", (Object)configuration.getKey());
            }
        } else if (configuration.getId() == null && !"NOT_SET".equals(configuration.getKey())) {
            Configuration existingConfiguration = (Configuration)this.pluginRepository.getByKey(configuration.getKey());
            if (existingConfiguration != null) {
                log.debug("Updating configuration with key {}", (Object)configuration.getKey());
                configuration.setId(existingConfiguration.getId());
            } else {
                log.debug("Saving new configuration with key {}", (Object)configuration.getKey());
            }
        }
        if ("NOT_SET".equals(configuration.getKey())) {
            configuration.setKey(null);
        }
    }

    @Override
    protected List<String> getSpaceKeys(Configuration configuration) {
        return Arrays.stream(configuration.getSpaceKey().split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected void doEnhancement(Configuration configuration) {
        super.doEnhancement((PluginEntity)configuration);
        this.enrichUsers(configuration.getConfiguration().getFilters().getIncludeUsers());
        this.enrichUsers(configuration.getConfiguration().getFilters().getExcludeUsers());
    }
}

