/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="StatisticController")
@Path(value="/statistics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatisticController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticController.class);
    private final StatisticService statisticService;

    @Inject
    public StatisticController(StatisticService statisticService) {
        this.statisticService = statisticService;
    }

    @Path(value="/{contentType}/{contentId}")
    @GET
    public StatisticsData get(@PathParam(value="contentType") StatisticsData.ContentType contentType, @PathParam(value="contentId") Long contentId) {
        return (StatisticsData)this.statisticService.getByKey(StatisticsData.getKey(contentType, contentId), true);
    }

    @Path(value="/{id}")
    @GET
    public StatisticsData get(@PathParam(value="id") Integer id) {
        return (StatisticsData)this.statisticService.get(id, true);
    }

    @GET
    public List<StatisticsData> getAll() {
        return this.statisticService.getAll(true);
    }

    @DELETE
    public Map<String, Integer> deleteAll() {
        return Map.of("count", this.statisticService.deleteAll(true));
    }

    @Path(value="/{id}")
    @DELETE
    public StatisticsData delete(@PathParam(value="id") Integer id) {
        return (StatisticsData)this.statisticService.delete(id, true);
    }
}

