/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.util.ConnectorUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class PluginDataMigrator
implements DiscoverableListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDataMigrator.class);
    private final List<PluginRepository<?>> pluginRepositories;

    @Inject
    public PluginDataMigrator(List<PluginRepository<?>> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void onStartAppMigration(AppCloudMigrationGateway migrationGateway, String transferId, MigrationDetailsV1 migrationDetails) {
        ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();
        this.pluginRepositories.forEach(pluginRepository -> {
            try {
                OutputStream outputStream = migrationGateway.createAppData(transferId, pluginRepository.getEntityType());
                String payload = objectMapper.writeValueAsString((Object)pluginRepository.getAll());
                outputStream.write(payload.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                log.error("Error uploading files to the cloud, type: " + pluginRepository.getEntityType(), (Throwable)e);
            }
        });
    }

    public String getCloudAppKey() {
        return "confluence-microsoft-teams-connector";
    }

    public String getServerAppKey() {
        return "confluence-microsoft-teams-connector";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

