/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ProgressStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.ProgressStatisticReportConfigurationRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.service.OperationListener;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProgressStatisticReportConfigurationService
extends AbstractStatisticsReportConfigurationService<ProgressStatisticReportConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressStatisticReportConfigurationService.class);
    private static final int MAX_COUNT = 20;

    @Inject
    public ProgressStatisticReportConfigurationService(ProgressStatisticReportConfigurationRepository repository, List<OperationListener> operationListeners, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager) {
        super(repository, operationListeners, validationHelper, userAccessor, pageManager, spaceManager);
    }

    @Override
    public void validate(ProgressStatisticReportConfiguration configuration) {
        Objects.requireNonNull(configuration, "Configuration is null");
        Objects.requireNonNull(configuration.getName(), "Configuration name is null");
        if (CollectionUtils.isEmpty((Collection)configuration.getSources()) && CollectionUtils.isEmpty(configuration.getAuthors())) {
            throw new IllegalArgumentException("No authors or pages/blog posts are specified");
        }
        if (configuration.getOwner() == null) {
            configuration.setOwner(this.validationHelper.getCurrentUser());
        }
        if (configuration.getOwner() == null) {
            throw new IllegalArgumentException("Owner is not set");
        }
        this.validateSources(configuration);
        this.validateDelivery(configuration);
        if (configuration.getContentAmount() <= 0 || configuration.getContentAmount() > 20) {
            throw new IllegalArgumentException("Content amount must be greater than 0 and less or equal to 20");
        }
    }

    public String getType() {
        return "progress-report";
    }

    public Class<ProgressStatisticReportConfiguration> getConfigurationClass() {
        return ProgressStatisticReportConfiguration.class;
    }

    @Override
    protected void doEnhancement(ProgressStatisticReportConfiguration configuration) {
        super.doEnhancement(configuration);
        this.enrichUsers(configuration.getAuthors());
        this.enrichUser(configuration.getOwner());
    }

    @Override
    public boolean shouldProcess(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        ConfluenceUser user = Optional.of(content.getCreator()).orElse(new ConfluenceUser(){

            public UserKey getKey() {
                return new UserKey("Anonymous");
            }

            public String getFullName() {
                return "Anonymous";
            }

            public String getEmail() {
                return null;
            }

            public String getName() {
                return "Anonymous";
            }
        });
        StatisticsData.ContentType contentType = StatisticService.getContentType(content);
        long contentId = content.getId();
        log.debug("Content author: {}/{}", (Object)user.getName(), (Object)user.getKey());
        List configurations = this.pluginRepository.getAll();
        boolean result = configurations.stream().anyMatch(c -> {
            boolean nonEmptyFilters = !CollectionUtils.isEmpty((Collection)c.getSources()) || !CollectionUtils.isEmpty(c.getAuthors());
            boolean sourceMatches = CollectionUtils.isEmpty((Collection)c.getSources()) || c.getSources().stream().anyMatch(s -> contentType.equals((Object)s.getContentType()) && contentId == s.getContentId());
            log.debug("Sources {} matches: {}", (Object)c.getSources(), (Object)sourceMatches);
            boolean authorMatches = CollectionUtils.isEmpty(c.getAuthors()) || c.getAuthors().stream().anyMatch(a -> a.getUserKey().equals(user.getKey().getStringValue()));
            log.debug("Authors {} matches: {}", c.getAuthors(), (Object)sourceMatches);
            return nonEmptyFilters && sourceMatches && authorMatches;
        });
        log.debug("Content type: {}, content ID: {}, should process: {}", new Object[]{contentType, contentId, result});
        return result;
    }
}

