/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.confluence.microsoftteams.notifier.model.AbstractConfluenceScheduledReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.SourceEntity;
import com.moveworkforward.model.User;
import com.moveworkforward.statistics.annotations.StatisticsEntity;
import com.moveworkforward.statistics.annotations.StatisticsField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"tag", "url", "urlId"})
@EntityType(value="task-reminder-report")
@StatisticsEntity(value="task-reminder-report")
public class TaskReminderReportConfiguration
extends AbstractConfluenceScheduledReportConfiguration<SourceEntity> {
    public static final String TYPE = "task-reminder-report";
    private int days;
    @StatisticsField
    private List<Expiration> expirations = new ArrayList<Expiration>();
    private int taskCount;
    private List<User> creatorsUsers = new ArrayList<User>();
    private List<User> assigneesUsers = new ArrayList<User>();
    private List<User> completeUsers = new ArrayList<User>();
    @StatisticsField
    private TaskStatus taskStatus;

    public String getType() {
        return TYPE;
    }

    @JsonIgnore
    public String getReportTime() {
        if (this.getDelivery() != null) {
            this.getDelivery().setDeliverOnSchedule(true);
        }
        return super.getReportTime();
    }

    public List<String> getSourceKeys() {
        if (CollectionUtils.isEmpty((Collection)this.sources)) {
            return new ArrayList<String>();
        }
        return this.sources.stream().map(SourceEntity::getSpaceKey).collect(Collectors.toList());
    }

    public void setSourceKeys(List<String> sourceKeys) {
        this.sources = CollectionUtils.isEmpty((Collection)this.sources) ? new ArrayList() : sourceKeys.stream().map(SourceEntity::new).collect(Collectors.toList());
    }

    @Generated
    public int getDays() {
        return this.days;
    }

    @Generated
    public List<Expiration> getExpirations() {
        return this.expirations;
    }

    @Generated
    public int getTaskCount() {
        return this.taskCount;
    }

    @Generated
    public List<User> getCreatorsUsers() {
        return this.creatorsUsers;
    }

    @Generated
    public List<User> getAssigneesUsers() {
        return this.assigneesUsers;
    }

    @Generated
    public List<User> getCompleteUsers() {
        return this.completeUsers;
    }

    @Generated
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @Generated
    public void setDays(int days) {
        this.days = days;
    }

    @Generated
    public void setExpirations(List<Expiration> expirations) {
        this.expirations = expirations;
    }

    @Generated
    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    @Generated
    public void setCreatorsUsers(List<User> creatorsUsers) {
        this.creatorsUsers = creatorsUsers;
    }

    @Generated
    public void setAssigneesUsers(List<User> assigneesUsers) {
        this.assigneesUsers = assigneesUsers;
    }

    @Generated
    public void setCompleteUsers(List<User> completeUsers) {
        this.completeUsers = completeUsers;
    }

    @Generated
    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    @Generated
    public String toString() {
        return "TaskReminderReportConfiguration(super=" + super.toString() + ", days=" + this.days + ", expirations=" + this.expirations + ", taskCount=" + this.taskCount + ", creatorsUsers=" + this.creatorsUsers + ", assigneesUsers=" + this.assigneesUsers + ", completeUsers=" + this.completeUsers + ", taskStatus=" + this.taskStatus + ")";
    }

    @Generated
    public TaskReminderReportConfiguration() {
    }

    public static enum Expiration {
        EXPIRED,
        EXPIRING_WITHIN,
        EXPIRING_AFTER,
        WITHOUT_DUE_DATE;

    }
}

