/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.component.AbstractUserSurveyManager;
import com.moveworkforward.confluence.microsoftteams.notifier.components.UserSurveyManager;
import com.moveworkforward.rest.AbstractUserSurveyController;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Path(value="/survey")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class UserSurveyController
extends AbstractUserSurveyController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserSurveyController.class);
    private final PermissionManager permissionManager;

    @Autowired
    public UserSurveyController(UserSurveyManager surveyManager, Environment environment, @ComponentImport PermissionManager permissionManager) {
        super((AbstractUserSurveyManager)surveyManager, environment);
        this.permissionManager = permissionManager;
    }

    protected boolean isAdmin(com.moveworkforward.model.User user) {
        return this.permissionManager.isConfluenceAdministrator((User)((ConfluenceUser)user.getUser())) || this.permissionManager.isSystemAdministrator((User)((ConfluenceUser)user.getUser()));
    }

    protected com.moveworkforward.model.User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return new com.moveworkforward.model.User((Object)confluenceUser, confluenceUser.getKey().getStringValue(), confluenceUser.getName());
    }

    @GET
    @Path(value="/data")
    public Map<String, Object> getSurveyData(@QueryParam(value="location") String locationStr) {
        com.moveworkforward.model.User user = this.getCurrentUser();
        UserSurveyManager.SurveyLocation location = StringUtils.isBlank((CharSequence)locationStr) ? UserSurveyManager.SurveyLocation.GLOBAL : UserSurveyManager.SurveyLocation.valueOf(locationStr.toUpperCase());
        Map data = this.surveyManager.getSurveyData(user, "ZQeG8ZUT", (AbstractUserSurveyManager.Location)location);
        return data == null ? Collections.emptyMap() : data;
    }
}

