/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.microsoftteams.notifier.components.EventNotifierImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.model.SpaceSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="SpaceSettingsController")
@Path(value="/space-settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SpaceSettingsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceSettingsController.class);
    private final GlobalSettingsService globalSettingsService;
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;

    @Autowired
    public SpaceSettingsController(GlobalSettingsService globalSettingsService, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        this.globalSettingsService = globalSettingsService;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @GET
    @Path(value="/{spaceKey}")
    public SpaceSettings get(@PathParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new IllegalArgumentException("Space is not found: " + spaceKey);
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space)) {
            throw new IllegalArgumentException("ConfluenceUser[key=" + user.getName() + "] does not have permissions for operation");
        }
        ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
        return new SpaceSettings(spaceKey, EventNotifierImpl.isAllowed(globalSettings, spaceKey), globalSettings.getUrlManagement());
    }
}

