/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.moveworkforward.confluence.microsoftteams.notifier.model.ApplicationUpdateConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ApplicationUpdateReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.model.AppVersion;
import com.moveworkforward.model.UpdateConfiguration;
import com.moveworkforward.model.VersionPayloadHolder;
import com.moveworkforward.report.AppVersionReportExecutor;
import com.moveworkforward.service.impl.AppVersionService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationUpdateReportExecutor
extends AbstractReportExecutor<ApplicationUpdateConfiguration, VersionPayloadHolder>
implements AppVersionReportExecutor<ApplicationUpdateConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationUpdateReportExecutor.class);
    protected final AppVersionService appVersionService;

    @Autowired
    public ApplicationUpdateReportExecutor(AbstractReportConfigurationService<ApplicationUpdateConfiguration> configurationService, UrlConfigurationServiceImpl urlConfigurationService, ApplicationUpdateReportCreator reportCreator, AppVersionService appVersionService) {
        super(configurationService, urlConfigurationService, reportCreator);
        this.appVersionService = appVersionService;
    }

    @Override
    protected VersionPayloadHolder getPayloadDataByConfiguration(ApplicationUpdateConfiguration configuration, Date date) {
        return this.getPayloadDataByConfiguration((UpdateConfiguration)configuration);
    }

    @Override
    protected void postExecute(Map<ApplicationUpdateConfiguration, VersionPayloadHolder> dataPerConfiguration, List<ApplicationUpdateConfiguration> configurations, List<ApplicationUpdateConfiguration> errorConfigurations) {
        dataPerConfiguration.values().forEach(payloadHolder -> {
            this.saveVersions(payloadHolder.getProductVersions());
            this.saveVersions(payloadHolder.getPluginVersions());
        });
        super.postExecute(dataPerConfiguration, configurations, errorConfigurations);
    }

    private void saveVersions(List<AppVersion> versions) {
        if (CollectionUtils.isEmpty(versions)) {
            return;
        }
        versions.forEach(version -> {
            AppVersion existingVersion = this.getAppVersionService().get(version.getKey());
            if (existingVersion != null) {
                version.setId(existingVersion.getId());
            }
            this.getAppVersionService().save(version);
        });
    }

    public Logger getLog() {
        return log;
    }

    @Generated
    public AppVersionService getAppVersionService() {
        return this.appVersionService;
    }
}

