/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.util.Option;
import com.atlassian.user.User;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.service.impl.AbstractGlobalSettingsService;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalSettingsService
extends AbstractGlobalSettingsService<ConfluenceGlobalSettings> {
    public static final String CONFLUENCE_LOCALE = "confluence.locale";
    public static final String CONFLUENCE_TIME_ZONE = "confluence.timezone";
    public static final String CONFLUENCE_TIME_FORMAT = "confluence.time.format";
    private final PermissionManager permissionManager;
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public GlobalSettingsService(PluginSettingRepository<ConfluenceGlobalSettings> repository, List<OperationListener> operationListeners, @ComponentImport PermissionManager permissionManager, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        super(repository, operationListeners);
        this.permissionManager = permissionManager;
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    protected String getUser() {
        return AuthenticatedUserThreadLocal.get().getName();
    }

    protected void hasUserAdminPermissions() {
        if (!this.permissionManager.isSystemAdministrator((User)AuthenticatedUserThreadLocal.get())) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }

    protected ConfluenceGlobalSettings getDefaultSettings() {
        return new ConfluenceGlobalSettings();
    }

    protected void merge(ConfluenceGlobalSettings existingEntity, ConfluenceGlobalSettings newEntity) {
        super.merge((AbstractGlobalSettings)existingEntity, (AbstractGlobalSettings)newEntity);
        newEntity.setUuid(existingEntity.getUuid());
    }

    public Map<String, String> getServerProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
        Locale locale = this.localeManager.getSiteDefaultLocale();
        for (FormatStyle formatStyle : FormatStyle.values()) {
            String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, formatStyle, IsoChronology.INSTANCE, locale);
            properties.put("confluence.time.format." + formatStyle.toString().toLowerCase(), pattern);
        }
        properties.put(CONFLUENCE_LOCALE, String.valueOf(locale));
        properties.put(CONFLUENCE_TIME_ZONE, String.valueOf(zone));
        return properties;
    }

    public void enrich(ConfluenceGlobalSettings globalSettings) {
        globalSettings.setProperties(this.getServerProperties());
        globalSettings.setLicense(this.getLicense());
    }

    private ConfluenceGlobalSettings.LicenseInfo getLicense() {
        ConfluenceGlobalSettings.LicenseInfo licenseInfo = new ConfluenceGlobalSettings.LicenseInfo("UNDEFINED", null, null);
        Option optionLicense = this.pluginLicenseManager.getLicense();
        if (optionLicense != null && optionLicense.isDefined()) {
            optionLicense.forEach(license -> {
                licenseInfo.setStatus("OK");
                license.getError().forEach(error -> licenseInfo.setStatus(error.toString()));
                license.getExpiryDate().forEach(dateTime -> licenseInfo.setExpirationDate(dateTime == null ? null : dateTime.toDate()));
                licenseInfo.setLicenseType(license.getLicenseType());
            });
        }
        return licenseInfo;
    }
}

