/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ContentStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ContentStatisticsDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.util.DateTimeUtil;
import com.moveworkforward.model.User;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentStatisticsReportCreator
extends AbstractReportCreator<ContentStatisticReportConfiguration, ContentStatisticsDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentStatisticsReportCreator.class);
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    protected ContentStatisticsReportCreator(@ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, DateTimeUtil dateTimeUtil) {
        super(i18nResolver, webResourceUrlProvider);
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    public String createPayload(ContentStatisticReportConfiguration configuration, ContentStatisticsDataHolder payloadHolder) {
        String sectionTitle;
        String subTitle = this.getPeriodString(configuration.getTimePeriod());
        String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
        String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
        MessageData messageData = new MessageData(configuration.getName(), subTitle, null);
        if (CollectionUtils.isNotEmpty(payloadHolder.getCreatedData())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.new.content");
            messageData.getItems().add(new MessageData.Item("new", sectionTitle, showText, hideText, this.getContent(payloadHolder.getCreatedData())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getStatisticsData())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.popular.content");
            messageData.getItems().add(new MessageData.Item("stats", sectionTitle, showText, hideText, this.getContent(payloadHolder.getStatisticsData())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getStaleData())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.stale.content");
            messageData.getItems().add(new MessageData.Item("stale", sectionTitle, showText, hideText, this.getContent(payloadHolder.getStaleData())));
        }
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        String payload = this.objectMapper.writeValueAsString((Object)message);
        log.debug("Content statistics report payload: {}", (Object)payload);
        return payload;
    }

    private List<String> getContent(Set<StatisticsData> createdData) {
        String baseUrl = this.getBaseUrl();
        ArrayList<String> items = new ArrayList<String>();
        createdData.forEach(c -> {
            String authorName = Optional.ofNullable(c.getAuthor()).map(User::getDisplayName).orElse("Unknown");
            String spaceName = (String)c.getAdditionalInfo().getOrDefault("spaceName", "");
            String lastEdited = c.getEditTimestamp() > 0L ? this.dateTimeUtil.formatDate(new Date(c.getEditTimestamp())) : (c.getCreateTimestamp() > 0L ? this.dateTimeUtil.formatDate(new Date(c.getCreateTimestamp())) : "-");
            StringBuilder builder = new StringBuilder(TeamsPayloadUtils.makeMicrosoftTeamsLink((String)c.getTitle(), (String)(baseUrl + c.getUrlPath())));
            builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.space", new Serializable[]{spaceName}));
            builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.author", new Serializable[]{authorName}));
            builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.lastedited", new Serializable[]{lastEdited}));
            builder.append(" \r- ").append(this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.stats", new Serializable[]{Integer.valueOf(c.getViewCount()), Integer.valueOf(c.getLikeCount()), Integer.valueOf(c.getCommentCount()), Integer.valueOf(c.getEditCount())}));
            builder.append(" \r");
            items.add(builder.toString());
        });
        return items;
    }
}

