/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceTaskBodyFormatter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceTaskBodyFormatter.class);
    private final UserAccessor userAccessor;
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;
    private final PageManager pageManager;
    private final String baseUrl;

    @Autowired
    public ConfluenceTaskBodyFormatter(@ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager) {
        this.userAccessor = userAccessor;
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
        this.pageManager = pageManager;
        this.baseUrl = webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String parseTaskBody(Task task) {
        if (task == null || task.getBody() == null) {
            return null;
        }
        String body = task.getBody();
        Pattern pattern = Pattern.compile("<span(.*?)>(.*?)</span>");
        Matcher matcher = pattern.matcher(body);
        String response = matcher.find() && matcher.groupCount() > 0 ? matcher.group(matcher.groupCount()) : body;
        response = this.parseUsers(response);
        response = this.parseDate(response);
        log.debug("parseTaskBody() -> " + response);
        return this.addLinkAndListToTaskBody(response.trim(), task.getContentId());
    }

    private String addLinkAndListToTaskBody(String body, long contentId) {
        String pageUrl = this.baseUrl + this.getPageLink(contentId);
        return "* [" + body + "](" + pageUrl + ")";
    }

    private String getPageLink(long contentId) {
        Page page = this.pageManager.getPage(contentId);
        if (page == null) {
            return null;
        }
        return page.getUrlPath();
    }

    private String parseUsers(String body) {
        String result = body;
        Pattern pattern = Pattern.compile("<ac:link><ri:user ri:userkey=\"(.*?)\" /></ac:link>");
        Matcher matcher = pattern.matcher(body);
        if (!matcher.find()) {
            log.debug("parseUsers() no match found for body " + body);
        } else if (matcher.groupCount() < 1) {
            log.debug("parseUsers() not enough groups found for body " + body);
        } else {
            do {
                String userKey = matcher.group(1);
                ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
                String replacement = null;
                if (user != null) {
                    replacement = user.getName();
                } else {
                    log.debug("parseUsers() user with key " + userKey + " not found");
                    replacement = matcher.group(1);
                }
                int index = result.indexOf(matcher.group(0));
                if (index > 0 && result.charAt(index - 1) != ' ') {
                    replacement = " " + replacement;
                }
                result = result.replace(matcher.group(0), replacement);
            } while (matcher.find());
        }
        return result;
    }

    private String parseDate(String body) {
        String result = body;
        Pattern pattern = Pattern.compile("<time datetime=\"(.*?)\" />");
        Matcher matcher = pattern.matcher(body);
        if (!matcher.find()) {
            log.debug("parseDate() no match found for body " + body);
        } else if (matcher.groupCount() < 1) {
            log.debug("parseDate() not enough groups found for body " + body);
        } else {
            do {
                String replacement = matcher.group(1);
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse(matcher.group(1));
                    replacement = this.formatDate(date);
                }
                catch (ParseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                int index = result.indexOf(matcher.group(0));
                if (index > 0 && result.charAt(index - 1) != ' ') {
                    replacement = " " + replacement;
                }
                result = result.replace(matcher.group(0), replacement);
            } while (matcher.find());
        }
        return result;
    }

    private String formatDate(Date date) {
        try {
            ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
            LocalDate localDate = LocalDate.from(date.toInstant().atZone(zone));
            return this.getDateTimeFormatter(FormatStyle.SHORT).format(localDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private DateTimeFormatter getDateTimeFormatter(FormatStyle formatStyle) {
        return DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(this.localeManager.getSiteDefaultLocale());
    }
}

