/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.CalendarEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.PayloadParameters;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionAndAnswerEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.util.DateTimeUtil;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MicrosoftTeamsEventCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsEventCreator.class);
    public static final String NAME = "name";
    public static final String VALUE = "value";
    private final DateTimeUtil dateTimeUtil;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    @Inject
    public MicrosoftTeamsEventCreator(DateTimeUtil dateTimeUtil) {
        this.dateTimeUtil = dateTimeUtil;
    }

    public static String absoluteUrl(String relativeUrl, String baseUrl) {
        return (baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl) + relativeUrl;
    }

    private static Collection<String> getFactsToKeep(Source source, boolean minimalContent) {
        if (!minimalContent) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        switch (source) {
            case COMMENT_UPDATED: 
            case COMMENT_CREATED: {
                result.add("Comment");
            }
        }
        return result;
    }

    public Map<Configuration, String> create(List<PayloadParameters> parametersList) {
        HashMap payloadMap = new HashMap();
        return parametersList.stream().collect(Collectors.toMap(PayloadParameters::getConfiguration, parameters -> {
            if (parameters.getEvent() == null) {
                return null;
            }
            Configuration configuration = parameters.getConfiguration();
            return payloadMap.computeIfAbsent(ImmutablePair.of((Object)configuration.isMinimalContent(), (Object)configuration.isExpandedCard()), pair -> this.create((PayloadParameters)parameters));
        }));
    }

    String create(PayloadParameters parameters) {
        Object event = parameters.getEvent();
        if (event == null) {
            return null;
        }
        if (event instanceof CommentEvent) {
            return this.createCommentCard(parameters);
        }
        if (event instanceof PageEvent) {
            return this.createPageCard(parameters);
        }
        if (event instanceof BlogPostEvent) {
            return this.createBlogPostCard(parameters);
        }
        if (event instanceof AttachmentEvent) {
            return this.createAttachmentCard(parameters);
        }
        if (event instanceof CalendarEventInfo) {
            return this.createCalendarCard(parameters);
        }
        if (event instanceof QuestionAndAnswerEventInfo) {
            return this.createQuestionAnswerCard(parameters);
        }
        log.error("MicrosoftTeamsEventCreator has not implementation for " + event.getClass().toString());
        return null;
    }

    String createCommentCard(PayloadParameters payloadParameters) {
        CommentEvent event = (CommentEvent)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String title = this.makeTitle(event, baseUrl);
        String subTitle = "";
        String actionTitle = "View Comment";
        String actionUrl = null;
        if (!(event instanceof CommentRemoveEvent)) {
            subTitle = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)event.getComment().getDisplayTitle(), (String)(baseUrl + event.getComment().getUrlPath()));
            actionUrl = baseUrl + event.getComment().getUrlPath();
        }
        List<Pair<String, String>> facts = this.getFacts((ContentEvent)event, baseUrl, source, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle(subTitle).setEvent((ContentEvent)event).setActionText(actionTitle).setActionUrl(actionUrl).setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    String createAttachmentCard(PayloadParameters payloadParameters) {
        AttachmentEvent event = (AttachmentEvent)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String title = this.makeTitle(event, baseUrl);
        String subTitle = "";
        if (!(event instanceof AttachmentRemoveEvent)) {
            Attachment attachment = event.getAttachment();
            String triggerDisplayName = attachment.getLastModifier().getFullName();
            String username = attachment.getLastModifier().getName();
            String userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)triggerDisplayName, (String)(baseUrl + "/display/~" + username));
            subTitle = String.format("by %s", userLink);
        }
        List<Pair<String, String>> facts = this.getFacts((ContentEvent)event, baseUrl, source, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle(subTitle).setEvent((ContentEvent)event).setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    String createPageCard(PayloadParameters payloadParameters) {
        PageEvent event = (PageEvent)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String title = this.makeTitle(event, baseUrl);
        String subTitle = "";
        String actionUrl = null;
        String actionTitle = "View Page";
        if (!(event instanceof PageRemoveEvent) && !(event instanceof PageTrashedEvent)) {
            actionUrl = baseUrl + event.getPage().getUrlPath();
            subTitle = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)event.getPage().getDisplayTitle(), (String)(baseUrl + event.getPage().getUrlPath()));
        }
        List<Pair<String, String>> facts = this.getFacts((ContentEvent)event, baseUrl, source, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle(subTitle).setEvent((ContentEvent)event).setActionText(actionTitle).setActionUrl(actionUrl).setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    String createBlogPostCard(PayloadParameters payloadParameters) {
        BlogPostEvent event = (BlogPostEvent)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String title = this.makeTitle(event, baseUrl);
        String subTitle = "";
        String actionUrl = null;
        String actionTitle = "View Blog post";
        if (!(event instanceof BlogPostRemoveEvent) && !(event instanceof BlogPostTrashedEvent)) {
            subTitle = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)event.getBlogPost().getDisplayTitle(), (String)(baseUrl + event.getBlogPost().getUrlPath()));
            actionUrl = baseUrl + event.getBlogPost().getUrlPath();
        }
        List<Pair<String, String>> facts = this.getFacts((ContentEvent)event, baseUrl, source, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle(subTitle).setEvent((ContentEvent)event).setActionText(actionTitle).setActionUrl(actionUrl).setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    String createCalendarCard(PayloadParameters payloadParameters) {
        CalendarEventInfo eventInfo = (CalendarEventInfo)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String triggerDisplayName = eventInfo.getTrigger().getFullName();
        String eventName = (String)StringUtils.defaultIfBlank((CharSequence)eventInfo.getDescription(), (CharSequence)eventInfo.getName());
        String calendarTypeName = eventInfo.getTypeName();
        String operation = this.getCalendarOperation(eventInfo.getSource());
        String title = String.format("%s %s the event %s in %s in the %s", triggerDisplayName, operation, eventName, calendarTypeName, eventInfo.getCalendarName());
        List<Pair<String, String>> facts = this.getCalendarFacts(eventInfo, baseUrl, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle("").setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    private List<Pair<String, String>> getCalendarFacts(CalendarEventInfo eventInfo, String baseUrl, boolean minimalContent) {
        ArrayList<Pair<String, String>> facts = new ArrayList<Pair<String, String>>();
        if (minimalContent) {
            return facts;
        }
        if (eventInfo.getTrigger() != null) {
            String userFullName = eventInfo.getTrigger().getFullName();
            String username = eventInfo.getTrigger().getName();
            String userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)userFullName, (String)(baseUrl + "/display/~" + username));
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Created by", (Object)userLink));
        }
        if (StringUtils.isNotEmpty((CharSequence)eventInfo.getSpaceUrlPath())) {
            String calendarLink = this.calendarLink(eventInfo.getSpaceUrlPath(), eventInfo.getName(), baseUrl);
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Calendar", (Object)calendarLink));
        }
        facts.add((Pair<String, String>)ImmutablePair.of((Object)"Invitees", (Object)this.getUserList(eventInfo.getInvitees(), eventInfo.getTrigger(), baseUrl)));
        facts.add((Pair<String, String>)ImmutablePair.of((Object)"Dates", (Object)this.dateTimeUtil.getDates(eventInfo.getStartTime(), eventInfo.getEndTime(), eventInfo.isAllDay())));
        return facts;
    }

    private String getCalendarOperation(Source source) {
        switch (source) {
            case CALENDAR_EVENT_UPDATED: {
                return "updated";
            }
            case CALENDAR_EVENT_DELETED: {
                return "deleted";
            }
        }
        return "created";
    }

    String createQuestionAnswerCard(PayloadParameters payloadParameters) {
        QuestionAndAnswerEventInfo eventInfo = (QuestionAndAnswerEventInfo)payloadParameters.getEvent();
        String baseUrl = payloadParameters.getBaseUrl();
        Source source = payloadParameters.getSource();
        boolean minimalContent = payloadParameters.getConfiguration().isMinimalContent();
        boolean expandedCard = payloadParameters.getConfiguration().isExpandedCard();
        String triggerDisplayName = eventInfo.getTrigger().getFullName();
        String title = eventInfo.getQuestionType() == QuestionType.ANSWER ? triggerDisplayName + " posted an answer" : triggerDisplayName + " posted a question";
        String subTitle = eventInfo.getTitle() != null ? TeamsPayloadUtils.makeMicrosoftTeamsLink((String)eventInfo.getTitle(), (String)(baseUrl + eventInfo.getUrlPath())) : TeamsPayloadUtils.makeMicrosoftTeamsLink((String)"Click here to view", (String)(baseUrl + eventInfo.getUrlPath()));
        List<Pair<String, String>> facts = this.getQuestionAnswerFacts(eventInfo, baseUrl, minimalContent);
        TeamsCardParameters parameters = new TeamsCardParameters().setBaseUrl(baseUrl).setTitle(title).setSubTitle(subTitle).setFacts(facts).setExpanded(expandedCard).setViewActions(payloadParameters.isViewActions());
        return this.createTeamsCard(parameters);
    }

    private List<Pair<String, String>> getQuestionAnswerFacts(QuestionAndAnswerEventInfo eventInfo, String baseUrl, boolean minimalContent) {
        Space space;
        ArrayList<Pair<String, String>> facts = new ArrayList<Pair<String, String>>();
        if (minimalContent) {
            return facts;
        }
        if (eventInfo.getTrigger() != null) {
            String triggerDisplayName = eventInfo.getTrigger().getFullName();
            String username = eventInfo.getTrigger().getName();
            String userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)triggerDisplayName, (String)(baseUrl + "/display/~" + username));
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Created by", (Object)userLink));
        }
        if ((space = eventInfo.getSpace()) != null) {
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Space", (Object)space.getDisplayTitle()));
        }
        if (StringUtils.isNotEmpty((CharSequence)eventInfo.getAbbreviateContent())) {
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Content", (Object)eventInfo.getAbbreviateContent()));
        }
        if (eventInfo.getTopics() != null && eventInfo.getTopics().size() > 0) {
            facts.add((Pair<String, String>)ImmutablePair.of((Object)"Labels", (Object)String.join((CharSequence)", ", eventInfo.getTopics())));
        }
        return facts;
    }

    private String createTeamsCard(TeamsCardParameters parameters) {
        MessageData messageData = new MessageData(parameters.getTitle(), parameters.getSubTitle(), null);
        MessageData.Item item = this.factsToItem(parameters.getFacts());
        if (item != null) {
            item.setExpanded(parameters.isExpanded());
            messageData.getItems().add(item);
        }
        if (parameters.isViewActions() && StringUtils.isNotBlank((CharSequence)parameters.getActionText()) && StringUtils.isNotBlank((CharSequence)parameters.getActionUrl())) {
            MessageData.Action action = new MessageData.Action(parameters.getActionText(), parameters.getActionUrl());
            messageData.getActions().add(action);
        }
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        try {
            return this.objectMapper.writeValueAsString((Object)message);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String calendarLink(String spaceUrlPath, String calendarName, String baseUrl) {
        return TeamsPayloadUtils.makeMicrosoftTeamsLink((String)calendarName, (String)MicrosoftTeamsEventCreator.absoluteUrl(spaceUrlPath + "/calendars", baseUrl));
    }

    private String getUserList(Set<ConfluenceUser> invitees, ConfluenceUser trigger, String baseUrl) {
        if (invitees.isEmpty()) {
            return "";
        }
        if (invitees.size() == 1 && invitees.iterator().next().getKey().equals((Object)trigger.getKey())) {
            return "";
        }
        List userLinks = invitees.stream().map(i -> TeamsPayloadUtils.makeMicrosoftTeamsLink((String)i.getFullName(), (String)(baseUrl + "/display/~" + i.getName()))).collect(Collectors.toList());
        return String.join((CharSequence)", ", userLinks.subList(0, userLinks.size() - 1));
    }

    private List<Pair<String, String>> getFacts(ContentEvent event, String baseUrl, Source source, boolean minimalContent) {
        String userLink;
        String username;
        String userFullName;
        Collection<String> factsToKeep = MicrosoftTeamsEventCreator.getFactsToKeep(source, minimalContent);
        ConfluenceUser createdBy = null;
        ConfluenceUser updatedBy = null;
        ConfluenceUser deletedBy = null;
        Space space = null;
        Page content = null;
        Date lastModified = null;
        String commentValue = null;
        LinkedHashMap<String, String> facts = new LinkedHashMap<String, String>();
        if (event instanceof PageEvent) {
            Page page = ((PageEvent)event).getPage();
            if (event instanceof PageCreateEvent) {
                createdBy = page.getCreator();
            } else if (event instanceof PageTrashedEvent) {
                createdBy = page.getCreator();
                deletedBy = this.getDeletedBy(event);
            } else {
                createdBy = page.getCreator();
                updatedBy = page.getLastModifier();
            }
            space = page.getSpace();
            lastModified = page.getLastModificationDate();
            content = page;
        } else if (event instanceof BlogPostEvent) {
            BlogPost blog = ((BlogPostEvent)event).getBlogPost();
            if (event instanceof BlogPostCreateEvent) {
                createdBy = blog.getCreator();
            } else if (event instanceof BlogPostTrashedEvent) {
                createdBy = blog.getCreator();
                deletedBy = this.getDeletedBy(event);
            } else {
                createdBy = blog.getCreator();
                updatedBy = blog.getLastModifier();
            }
            space = blog.getSpace();
            lastModified = blog.getLastModificationDate();
            content = blog;
        } else if (event instanceof CommentEvent) {
            Comment comment = ((CommentEvent)event).getComment();
            if (event instanceof CommentCreateEvent) {
                createdBy = comment.getCreator();
            } else {
                createdBy = comment.getCreator();
                updatedBy = comment.getLastModifier();
            }
            commentValue = StringUtils.abbreviate((String)comment.getBodyAsStringWithoutMarkup(), (int)1000);
            space = comment.getSpace();
            lastModified = comment.getLastModificationDate();
            content = comment.getContainer();
        } else if (event instanceof AttachmentEvent) {
            Attachment attachment = ((AttachmentEvent)event).getAttachment();
            if (((AttachmentEvent)event).getAttachments().size() == 1) {
                commentValue = attachment.getVersionComment();
            }
            content = ((AttachmentEvent)event).getAttachedTo();
            lastModified = attachment.getLastModificationDate();
            space = attachment.getSpace();
        }
        if (commentValue != null) {
            facts.put("Comment", commentValue);
        }
        if (deletedBy != null) {
            userFullName = deletedBy.getFullName();
            username = deletedBy.getName();
            userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)userFullName, (String)(baseUrl + "/display/~" + username));
            facts.put("Deleted by", userLink);
        } else if (updatedBy != null) {
            userFullName = updatedBy.getFullName();
            username = updatedBy.getName();
            userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)userFullName, (String)(baseUrl + "/display/~" + username));
            facts.put("Updated by", userLink);
        }
        if (lastModified != null) {
            String lastModifiedDateFormatted = this.dateTimeUtil.formatDate(lastModified);
            facts.put("Updated at", lastModifiedDateFormatted);
        }
        if (createdBy != null) {
            userFullName = createdBy.getFullName();
            username = createdBy.getName();
            userLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)userFullName, (String)(baseUrl + "/display/~" + username));
            facts.put("Created by", userLink);
        }
        if (content != null) {
            String contentLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)content.getDisplayTitle(), (String)(baseUrl + content.getUrlPath()));
            facts.put("Content", contentLink);
        }
        if (space != null) {
            String spaceLink = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)space.getDisplayTitle(), (String)(baseUrl + space.getUrlPath()));
            facts.put("Space", spaceLink);
        }
        return facts.entrySet().stream().filter(entry -> factsToKeep == null || factsToKeep.contains(entry.getKey())).map(e -> ImmutablePair.of((Object)((String)e.getKey()), (Object)((String)e.getValue()))).collect(Collectors.toList());
    }

    private String makeTitle(CommentEvent event, String baseUrl) {
        if (event == null) {
            return "";
        }
        Comment comment = event.getComment();
        String username = comment.getLastModifier().getFullName();
        String page = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)comment.getContainer().getDisplayTitle(), (String)(baseUrl + comment.getContainer().getUrlPath()));
        return String.format("A comment in the page '%s' was %s by %s", page, comment.isNew() ? "created" : "updated", username);
    }

    private String makeTitle(AttachmentEvent event, String baseUrl) {
        if (event == null) {
            return "";
        }
        ContentEntityObject attachedTo = event.getAttachedTo();
        Attachment attachment = event.getAttachment();
        String page = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)attachedTo.getDisplayTitle(), (String)(baseUrl + attachedTo.getUrlPath()));
        return String.format("An attachment to the content '%s' was %s", page, attachment.isNew() ? "created" : "updated");
    }

    private String makeTitle(PageEvent event, String baseUrl) {
        if (event == null) {
            return "";
        }
        String action = "changed";
        String username = event.getPage().getLastModifier().getFullName();
        String page = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)event.getPage().getDisplayTitle(), (String)(baseUrl + event.getPage().getUrlPath()));
        if (event instanceof PageCreateEvent) {
            action = "created";
        } else if (event instanceof PageUpdateEvent) {
            action = "updated";
        } else if (event instanceof PageRemoveEvent || event instanceof PageTrashedEvent) {
            page = event.getPage().getDisplayTitle();
            action = "removed";
            if (event instanceof PageTrashedEvent) {
                ConfluenceUser user = this.getDeletedBy((ContentEvent)event);
                user = user == null ? AuthenticatedUserThreadLocal.get() : user;
                username = user == null ? "Unknown" : user.getFullName();
            }
        } else if (event instanceof PageRestoreEvent) {
            action = "restored";
        }
        return String.format("Page '%s' was %s by %s.", page, action, username);
    }

    private String makeTitle(BlogPostEvent event, String baseUrl) {
        if (event == null) {
            return "";
        }
        String blogPost = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)event.getBlogPost().getDisplayTitle(), (String)(baseUrl + event.getBlogPost().getUrlPath()));
        String action = "changed";
        String username = event.getBlogPost().getLastModifier().getFullName();
        if (event instanceof BlogPostCreateEvent) {
            action = "created";
        } else if (event instanceof BlogPostUpdateEvent) {
            action = "updated";
        } else if (event instanceof BlogPostRemoveEvent || event instanceof BlogPostTrashedEvent) {
            blogPost = event.getBlogPost().getDisplayTitle();
            action = "removed";
            if (event instanceof BlogPostTrashedEvent) {
                ConfluenceUser user = this.getDeletedBy((ContentEvent)event);
                user = user == null ? AuthenticatedUserThreadLocal.get() : user;
                username = user == null ? "Unknown" : user.getFullName();
            }
        } else if (event instanceof BlogPostRestoreEvent) {
            action = "restored";
        }
        return String.format("Blog post '%s' was %s by %s.", blogPost, action, username);
    }

    private ConfluenceUser getDeletedBy(ContentEvent event) {
        ConfluenceUser user = null;
        if (event instanceof PageTrashedEvent) {
            user = (ConfluenceUser)((PageTrashedEvent)event).getOriginatingUser();
        } else if (event instanceof BlogPostTrashedEvent) {
            user = (ConfluenceUser)((BlogPostTrashedEvent)event).getOriginatingUser();
        }
        return user;
    }

    public MessageData.Item factsToItem(List<Pair<String, String>> facts) {
        if (facts == null || facts.size() == 0) {
            return null;
        }
        ArrayList items = new ArrayList();
        facts.forEach(pair -> {
            String value = StringUtils.isBlank((CharSequence)((CharSequence)pair.getValue())) ? "" : (String)pair.getValue();
            items.add(Arrays.asList(MessageData.WidthContent.builder().text("**" + (String)pair.getKey() + "**").width("100px").build(), MessageData.WidthContent.builder().text(value).build()));
        });
        return new MessageData.Item("facts", "", "Show", "Hide", items);
    }

    private static class TeamsCardParameters {
        private String baseUrl;
        private ContentEvent event;
        private String title;
        private String subTitle;
        private String actionText;
        private String actionUrl;
        private List<Pair<String, String>> facts;
        private boolean expanded;
        private boolean viewActions = true;

        private TeamsCardParameters() {
        }

        @Generated
        public TeamsCardParameters setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public TeamsCardParameters setEvent(ContentEvent event) {
            this.event = event;
            return this;
        }

        @Generated
        public TeamsCardParameters setTitle(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public TeamsCardParameters setSubTitle(String subTitle) {
            this.subTitle = subTitle;
            return this;
        }

        @Generated
        public TeamsCardParameters setActionText(String actionText) {
            this.actionText = actionText;
            return this;
        }

        @Generated
        public TeamsCardParameters setActionUrl(String actionUrl) {
            this.actionUrl = actionUrl;
            return this;
        }

        @Generated
        public TeamsCardParameters setFacts(List<Pair<String, String>> facts) {
            this.facts = facts;
            return this;
        }

        @Generated
        public TeamsCardParameters setExpanded(boolean expanded) {
            this.expanded = expanded;
            return this;
        }

        @Generated
        public TeamsCardParameters setViewActions(boolean viewActions) {
            this.viewActions = viewActions;
            return this;
        }

        @Generated
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Generated
        public ContentEvent getEvent() {
            return this.event;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getSubTitle() {
            return this.subTitle;
        }

        @Generated
        public String getActionText() {
            return this.actionText;
        }

        @Generated
        public String getActionUrl() {
            return this.actionUrl;
        }

        @Generated
        public List<Pair<String, String>> getFacts() {
            return this.facts;
        }

        @Generated
        public boolean isExpanded() {
            return this.expanded;
        }

        @Generated
        public boolean isViewActions() {
            return this.viewActions;
        }
    }
}

