/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.validators;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ValidationConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel;
import com.moveworkforward.v2.validation.AbstractRecordValidator;
import jakarta.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneralRecordValidator
extends AbstractRecordValidator {
    private static final Logger log = LoggerFactory.getLogger(GeneralRecordValidator.class);
    @Autowired
    @ComponentImport
    protected PermissionManager permissionManager;
    @Autowired
    @ComponentImport
    protected SpaceManager spaceManager;

    protected Validator getValidator() {
        return ValidationConfiguration.getValidator();
    }

    public com.moveworkforward.model.User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return new com.moveworkforward.model.User((Object)confluenceUser, confluenceUser.getKey().getStringValue(), confluenceUser.getName());
    }

    public boolean hasTagPermission(String tag, String level) {
        Space space;
        com.moveworkforward.model.User user = this.getCurrentUser();
        if (ConfigurationLevel.PERSONAL.toString().equals(level)) {
            return tag.equals(user.getUserKey());
        }
        if (ConfigurationLevel.SPACE.toString().equals(level) && (space = this.getSpace(tag)) != null) {
            return this.permissionManager.hasPermission((User)((ConfluenceUser)user.getUser()), Permission.ADMINISTER, (Object)space);
        }
        return this.permissionManager.isConfluenceAdministrator((User)((ConfluenceUser)user.getUser())) || this.permissionManager.isSystemAdministrator((User)((ConfluenceUser)user.getUser()));
    }

    public Space getSpace(String spaceKey) {
        Space space = null;
        try {
            space = this.spaceManager.getSpace(spaceKey);
        }
        catch (Exception e) {
            log.error("Space is not found by key: {}", (Object)spaceKey);
        }
        return space;
    }
}

