/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.confluence.microsoftteams.notifier.model.AbstractStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TimePeriod;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.model.Delivery;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.util.DayTimeUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractStatisticsReportConfigurationService<T extends AbstractStatisticReportConfiguration>
extends AbstractReportConfigurationService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStatisticsReportConfigurationService.class);
    protected final PageManager pageManager;
    protected final SpaceManager spaceManager;

    public AbstractStatisticsReportConfigurationService(PluginRepository<T> repository, ConfigurationAuditService auditService, ValidationHelper validationHelper, UserAccessor userAccessor, PageManager pageManager, SpaceManager spaceManager) {
        super(repository, auditService, validationHelper, userAccessor);
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public void validate(T configuration) {
        Objects.requireNonNull(configuration, "Configuration is null");
        Objects.requireNonNull(configuration.getName(), "Configuration name is null");
        if (CollectionUtils.isEmpty((Collection)configuration.getSources())) {
            throw new IllegalArgumentException("Nothing to check, pages/blog posts are not specified");
        }
        this.validateSources(configuration);
        this.validateDelivery(configuration);
    }

    protected void validateSources(T configuration) {
        configuration.getSources().forEach(s -> {
            if (StringUtils.isBlank((CharSequence)s.getSpaceKey()) && (s.getContentType() == null || s.getContentId() == null)) {
                throw new IllegalArgumentException("Space key or Content type and content ID must be specified");
            }
        });
    }

    protected void validateDelivery(T configuration) {
        Delivery delivery = Optional.ofNullable(configuration.getDelivery()).orElse(new Delivery());
        configuration.setDelivery(delivery);
        delivery.setDeliverOnSchedule(true);
        if (StringUtils.isBlank((CharSequence)delivery.getDate())) {
            if (((AbstractStatisticReportConfiguration)((Object)configuration)).getTimePeriod() == null) {
                throw new IllegalArgumentException("Either 'date' or 'time period' must be specified");
            }
            DateTime now = new DateTime();
            DateTime scheduledTime = now.withHourOfDay(Optional.ofNullable(delivery.getHour()).orElse(0).intValue()).withMinuteOfHour(Optional.ofNullable(delivery.getMinute()).orElse(0).intValue());
            if (now.isAfter((ReadableInstant)scheduledTime) || now.withSecondOfMinute(0).withMillisOfSecond(0).equals((Object)scheduledTime.withSecondOfMinute(0).withMillisOfSecond(0))) {
                scheduledTime = now.plus((ReadableDuration)((AbstractStatisticReportConfiguration)((Object)configuration)).getTimePeriod().getPeriod().toStandardDuration());
            }
            delivery.setDate(DayTimeUtil.DATE_FORMAT.format(scheduledTime.toDate()));
        } else {
            try {
                Date date = DayTimeUtil.DATE_FORMAT.parse(delivery.getDate());
                if (((AbstractStatisticReportConfiguration)((Object)configuration)).getTimePeriod() == null) {
                    Period period = Period.fieldDifference((ReadablePartial)new LocalDateTime().withHourOfDay(delivery.getHour().intValue()).withMinuteOfHour(delivery.getMinute().intValue()), (ReadablePartial)LocalDateTime.fromDateFields((Date)date).withHourOfDay(delivery.getHour().intValue()).withMinuteOfHour(delivery.getMinute().intValue()));
                    for (TimePeriod.TimeUnit timeUnit : TimePeriod.TimeUnit.values()) {
                        int interval = Math.abs(period.get(timeUnit.getDurationFieldType()));
                        if (interval <= 0) continue;
                        TimePeriod timePeriod = new TimePeriod(interval, timeUnit);
                        ((AbstractStatisticReportConfiguration)((Object)configuration)).setTimePeriod(timePeriod);
                        break;
                    }
                }
                if (((AbstractStatisticReportConfiguration)((Object)configuration)).getTimePeriod() == null) {
                    throw new IllegalArgumentException("'Time period' is not defined");
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Date must match pattern \"yyyy-MM-dd\"");
            }
        }
        configuration.setDelivery(delivery);
    }

    @Override
    protected List<String> getSpaceKeys(T configuration) {
        return configuration.getSources().stream().map(s -> {
            try {
                if (StringUtils.isNotBlank((CharSequence)s.getSpaceKey())) {
                    return s.getSpaceKey();
                }
                if (StatisticsData.ContentType.BLOG_POST.equals((Object)s.getContentType())) {
                    return Optional.ofNullable(this.pageManager.getBlogPost(s.getContentId().longValue())).map(SpaceContentEntityObject::getSpaceKey).orElse(null);
                }
                return Optional.ofNullable(this.pageManager.getPage(s.getContentId().longValue())).map(SpaceContentEntityObject::getSpaceKey).orElse(null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected List<T> enhanceConfigurations(List<T> configurations, boolean perform) {
        return super.enhanceConfigurations(configurations, true);
    }

    protected T enhanceConfiguration(T configuration, boolean perform) {
        return (T)((Object)((AbstractStatisticReportConfiguration)super.enhanceConfiguration(configuration, true)));
    }

    protected void doEnhancement(T configuration) {
        super.doEnhancement(configuration);
        configuration.getSources().stream().filter(s -> s.getContentType() != null && s.getContentId() != null).forEach(s -> {
            Optional<SpaceContentEntityObject> optional = Optional.ofNullable(this.getContentEntity(s.getContentType(), s.getContentId()));
            optional.ifPresent(e -> {
                s.setTitle(e.getTitle());
                s.setUrlPath(e.getUrlPath());
                s.setSpaceKey(e.getSpaceKey());
            });
        });
    }

    public SpaceContentEntityObject getContentEntity(StatisticsData.ContentType contentType, Long contentId) {
        Object result = null;
        try {
            result = StatisticsData.ContentType.BLOG_POST.equals((Object)contentType) ? this.pageManager.getBlogPost(contentId.longValue()) : this.pageManager.getPage(contentId.longValue());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public SpaceContentEntityObject getContentEntity(Long contentId) {
        return this.pageManager.getAbstractPage(contentId.longValue());
    }

    public List<Page> getPages(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.warn("Space is not found by key: {}", (Object)spaceKey);
            return Collections.emptyList();
        }
        return this.pageManager.getPages(space, true);
    }

    public List<BlogPost> getBlogPosts(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.warn("Space is not found by key: {}", (Object)spaceKey);
            return Collections.emptyList();
        }
        return this.pageManager.getBlogPosts(space, true);
    }

    public abstract boolean shouldProcess(StatisticsEvent var1);

    public Map<String, Object> getAdditionalInfo(StatisticsEvent statisticsEvent) {
        return Collections.emptyMap();
    }
}

