/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.UserAccessor;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.ScheduledPluginRepository;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractConfluenceConfigurationService;
import com.moveworkforward.model.ScheduledPluginEntity;
import com.moveworkforward.service.CallBackReportService;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.service.ReportService;
import com.moveworkforward.util.DayTimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportConfigurationService<T extends ScheduledPluginEntity>
extends AbstractConfluenceConfigurationService<T>
implements CallBackReportService,
ReportService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractReportConfigurationService.class);
    protected final List<CallBackReportService.OperationCallback> callbacks = new ArrayList<CallBackReportService.OperationCallback>();

    public AbstractReportConfigurationService(PluginRepository<T> repository, ConfigurationAuditService auditService, ValidationHelper validationHelper, UserAccessor userAccessor) {
        super(repository, auditService, validationHelper, userAccessor);
    }

    public List<T> getConfigurationsForDate(Date date, boolean skipDateValidation) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int calendarDay = calendar.get(7);
        int hour = calendar.get(11);
        int minute = DayTimeUtil.adjustMinute((int)calendar.get(12));
        DayTimeUtil.Day day = DayTimeUtil.getDay((int)calendarDay);
        log.debug("{} day, {} hour, {} minute", new Object[]{day, hour, minute});
        LinkedHashSet configurations = new LinkedHashSet();
        if (skipDateValidation) {
            configurations.addAll(this.getAll(false));
        } else {
            ScheduledPluginRepository scheduledPluginRepository = (ScheduledPluginRepository)this.pluginRepository;
            configurations.addAll(scheduledPluginRepository.getByDateAndTime(day.getNumber(), hour, minute));
            configurations.addAll(scheduledPluginRepository.getByDateAndTime(date, hour, minute));
        }
        log.debug("Count of report configurations: {}", (Object)configurations.size());
        return this.enhanceConfigurations(new ArrayList(configurations), skipDateValidation);
    }

    public T save(T entity, boolean checkPermissions) {
        ScheduledPluginEntity result = (ScheduledPluginEntity)super.save(entity, checkPermissions);
        this.onSave(result);
        return (T)result;
    }

    public void validate(T configuration) {
        super.validate(configuration);
        Objects.requireNonNull(configuration.getDelivery(), "Delivery is null");
        Objects.requireNonNull(configuration.getName(), "Configuration name is null");
    }

    protected void onSave(T configuration) {
        try {
            this.callbacks.parallelStream().forEach(callback -> callback.onSave(configuration));
        }
        catch (Exception var3) {
            log.error(var3.getMessage(), (Throwable)var3);
        }
    }

    public void addCallBack(CallBackReportService.OperationCallback callback) {
        try {
            callback.onCount(this.pluginRepository.count());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.callbacks.add(callback);
    }
}

