/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"period"})
public class TimePeriod {
    private static final int DAYS_IN_WEEK = 7;
    private int interval;
    private TimeUnit timeUnit = TimeUnit.DAY;

    public Period getPeriod() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException("Time unit is not set");
        }
        switch (this.timeUnit) {
            case MINUTE: {
                return Period.minutes((int)this.interval);
            }
            case HOUR: {
                return Period.hours((int)this.interval);
            }
            case DAY: {
                return Period.days((int)this.interval);
            }
            case WEEK: {
                return Period.days((int)(this.interval * 7));
            }
            case MONTH: {
                return Period.months((int)this.interval);
            }
            case YEAR: {
                return Period.years((int)this.interval);
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + (Object)((Object)this.timeUnit));
    }

    public int getInterval() {
        return this.interval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String toString() {
        return "TimePeriod(super=" + super.toString() + ", interval=" + this.interval + ", timeUnit=" + (Object)((Object)this.timeUnit) + ")";
    }

    public TimePeriod() {
    }

    public TimePeriod(int interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public static enum TimeUnit {
        YEAR(DurationFieldType.years(), "com.moveworkforward.confluence.microsoft.teams.year"),
        MONTH(DurationFieldType.months(), "com.moveworkforward.confluence.microsoft.teams.month"),
        WEEK(DurationFieldType.weeks(), "com.moveworkforward.confluence.microsoft.teams.week"),
        DAY(DurationFieldType.days(), "com.moveworkforward.confluence.microsoft.teams.day"),
        HOUR(DurationFieldType.hours(), "com.moveworkforward.confluence.microsoft.teams.hour"),
        MINUTE(DurationFieldType.minutes(), "com.moveworkforward.confluence.microsoft.teams.minute");

        private final DurationFieldType durationFieldType;
        private final String localizationKey;

        private TimeUnit(DurationFieldType durationFieldType, String localizationKey) {
            this.durationFieldType = durationFieldType;
            this.localizationKey = localizationKey;
        }

        public DurationFieldType getDurationFieldType() {
            return this.durationFieldType;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }
}

