/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import com.moveworkforward.confluence.microsoftteams.notifier.model.MatchingStrategy;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtils {
    private static final Logger log = LoggerFactory.getLogger(FilterUtils.class);
    public static Comparator<StatisticsData> POPULAR_COMPARATOR = (o1, o2) -> o2.getLikeCount() + o2.getViewCount() + o2.getCommentCount() - (o1.getLikeCount() + o1.getViewCount() + o1.getCommentCount());

    private FilterUtils() {
    }

    public static boolean isLabelAccepted(Collection<String> configLabels, MatchingStrategy matchingStrategy, Collection<String> contentLabels) {
        if (CollectionUtils.isEmpty(configLabels)) {
            log.debug("Configuration labels are empty");
            return true;
        }
        if (CollectionUtils.isEmpty(contentLabels)) {
            log.debug("Content labels are empty");
            return false;
        }
        boolean result = true;
        if (matchingStrategy == MatchingStrategy.ALL) {
            result = configLabels.stream().allMatch(configLabel -> contentLabels.stream().anyMatch(l -> l.equalsIgnoreCase((String)configLabel)));
        } else if (matchingStrategy == MatchingStrategy.ANY) {
            result = configLabels.stream().anyMatch(configLabel -> contentLabels.stream().anyMatch(l -> l.equalsIgnoreCase((String)configLabel)));
        }
        log.debug("matchingStrategy {}, configuration labels {}, content labels {}, result {}", new Object[]{matchingStrategy, String.join((CharSequence)"||", configLabels), String.join((CharSequence)"||", contentLabels), result});
        return result;
    }

    public static boolean isGroupAccepted(List<String> configGroups, List<String> contentGroups) {
        if (CollectionUtils.isEmpty(configGroups)) {
            log.debug("Configuration groups are empty");
            return true;
        }
        if (CollectionUtils.isEmpty(contentGroups)) {
            log.debug("Content user groups are empty");
            return false;
        }
        boolean result = !CollectionUtils.intersection(configGroups, contentGroups).isEmpty();
        log.debug("Content user groups {} is on a configuration groups {}, result: {}", new Object[]{contentGroups, configGroups, result});
        return result;
    }

    public static boolean isUserAccepted(Collection<User> configUsers, User contentUser, String userType) {
        return FilterUtils.isUserAccepted(configUsers, contentUser, userType, CheckStrategy.CONTAINS);
    }

    public static boolean isUserAccepted(Collection<User> configUsers, User contentUser, String userType, CheckStrategy checkStrategy) {
        List<User> contentUsers = contentUser == null || StringUtils.isBlank((CharSequence)contentUser.getUserKey()) ? Collections.emptyList() : Collections.singletonList(contentUser);
        return FilterUtils.isUsersAccepted(configUsers, contentUsers, userType, checkStrategy);
    }

    public static boolean isUsersAccepted(Collection<User> configUsers, Collection<User> contentUsers, String userType) {
        return FilterUtils.isUsersAccepted(configUsers, contentUsers, userType, CheckStrategy.CONTAINS);
    }

    public static boolean isUsersAccepted(Collection<User> configUsers, Collection<User> contentUsers, String userType, CheckStrategy checkStrategy) {
        log.debug("Checking: {}, checking strategy, {}", (Object)userType, (Object)checkStrategy);
        if (CollectionUtils.isEmpty(configUsers)) {
            log.debug("Configuration users are empty");
            return true;
        }
        boolean result = false;
        if (CollectionUtils.isEmpty(contentUsers)) {
            result = CheckStrategy.NOT_CONTAINS.equals((Object)checkStrategy);
            log.debug("User is unknown, result: {}", (Object)result);
            return result;
        }
        boolean intersected = CollectionUtils.containsAny(configUsers, contentUsers);
        result = CheckStrategy.CONTAINS.equals((Object)checkStrategy) ? intersected : !intersected;
        log.debug("Users {} is in a config list {}, result: {}", new Object[]{contentUsers, configUsers, result});
        return result;
    }

    public static <T> Set<T> trim(Collection<T> data, int contentAmount) {
        return new LinkedHashSet<T>(new ArrayList<T>(data).subList(0, Math.min(contentAmount, data.size())));
    }

    public static Set<StatisticsData> sortByPopularity(Collection<StatisticsData> data) {
        ArrayList<StatisticsData> list = new ArrayList<StatisticsData>(data);
        list.sort(POPULAR_COMPARATOR);
        return new LinkedHashSet<StatisticsData>(list);
    }

    public static enum CheckStrategy {
        CONTAINS,
        NOT_CONTAINS;

    }
}

