/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.model.ScheduledPluginEntity;
import com.moveworkforward.report.PayloadDataHolder;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.DayTimeUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReportConfigurationTester {
    private static final Logger log = LoggerFactory.getLogger(ReportConfigurationTester.class);
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)false);

    public <T extends ScheduledPluginEntity, C extends PayloadDataHolder> Map<String, Object> testConfiguration(String dateString, Boolean send, T configuration, AbstractReportExecutor reportExecutor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean skipDateValidation = true;
        try {
            Date date = new Date();
            if (!StringUtils.isEmpty((Object)dateString)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                date = dateFormat.parse(dateString);
                skipDateValidation = false;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(12, DayTimeUtil.adjustMinute((int)calendar.get(12)));
            Map<Object, Object> contentPerConfiguration = new HashMap();
            if (configuration == null) {
                contentPerConfiguration = reportExecutor.getPayloadData(null, calendar.getTime(), skipDateValidation);
            } else {
                contentPerConfiguration.put(configuration, reportExecutor.getPayloadDataByConfiguration(configuration, calendar.getTime()));
            }
            if (Boolean.TRUE.equals(send)) {
                contentPerConfiguration.forEach(reportExecutor::createPayloadAndSend);
                result.put("status", "ok");
            } else {
                LinkedHashMap content = new LinkedHashMap();
                contentPerConfiguration.forEach((c, resource) -> {
                    String payload = reportExecutor.getReportCreator().createPayload((ScheduledPluginEntity)c, resource);
                    content.put(c.getName(), payload);
                });
                result.put("content", this.objectMapper.writeValueAsString(content));
                result.put("status", "ok");
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            result.put("status", "failure");
            result.put("error", ex.getMessage());
        }
        return result;
    }
}

