/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.moveworkforward.ao.entity.ScheduledEntity;
import com.moveworkforward.component.SendPayloadTask;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ConfluenceScheduledReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.model.DestinationHolder;
import com.moveworkforward.report.PayloadDataHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractReportExecutor<T extends ScheduledEntity & DestinationHolder, C extends PayloadDataHolder>
implements ConfluenceScheduledReportExecutor<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractReportExecutor.class);
    protected final AbstractReportConfigurationService<T> configurationService;
    protected final UrlConfigurationServiceImpl urlConfigurationService;
    protected final ReportCreator<T, C> reportCreator;
    protected boolean isReschedule = false;

    protected AbstractReportExecutor(AbstractReportConfigurationService<T> configurationService, UrlConfigurationServiceImpl urlConfigurationService, ReportCreator<T, C> reportCreator) {
        this.configurationService = configurationService;
        this.urlConfigurationService = urlConfigurationService;
        this.reportCreator = reportCreator;
    }

    public void executeReports() {
        boolean skipDateValidation = false;
        Date date = new Date();
        List<T> configurations = this.configurationService.getConfigurationsForDate(date, skipDateValidation);
        Map<T, C> dataPerConfiguration = this.getPayloadData(configurations, date, skipDateValidation);
        ArrayList errorConfigurations = new ArrayList();
        dataPerConfiguration.forEach((configuration, data) -> {
            try {
                if (data == null || !data.isEmpty()) {
                    this.createPayloadAndSend(configuration, data);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorConfigurations.add(configuration);
            }
        });
        this.postExecute(dataPerConfiguration, configurations, errorConfigurations);
    }

    protected void postExecute(Map<T, C> dataPerConfiguration, List<T> configurations, List<T> errorConfigurations) {
        if (this.isReschedule) {
            this.reScheduleConfigurations(configurations);
        }
    }

    protected void reScheduleConfigurations(List<T> configurations) {
        configurations.forEach(configuration -> {
            log.debug("Re-schedule report, {}", configuration);
            configuration.getDelivery().setDate(null);
            this.configurationService.save((ScheduledEntity)configuration, false);
        });
    }

    public Map<T, C> getPayloadData(List<T> configurations, Date date, boolean skipDateValidation) {
        configurations = configurations == null ? this.configurationService.getConfigurationsForDate(date, skipDateValidation) : configurations;
        LinkedHashMap result = new LinkedHashMap();
        if (CollectionUtils.isEmpty(configurations)) {
            log.debug("Configuration is not found for date: {}", (Object)date);
            return result;
        }
        configurations.forEach(c -> {
            C contentResourceHolder = this.getPayloadDataByConfiguration(c, date);
            result.put(c, contentResourceHolder);
        });
        return result;
    }

    protected abstract C getPayloadDataByConfiguration(T var1, Date var2);

    protected void createPayloadAndSend(T configuration, C contentResourceHolder) {
        String payload = this.reportCreator.createPayload(configuration, contentResourceHolder);
        this.sendReport((DestinationHolder)configuration, payload);
    }

    public void sendReport(DestinationHolder configuration, String reportBody) {
        try {
            log.debug("Configuration {}", (Object)configuration);
            log.debug("Report {}", (Object)reportBody);
            if (StringUtils.isEmpty((Object)reportBody)) {
                log.warn("Report for \"{}\" is empty, nothing to send", (Object)configuration.getName());
                return;
            }
            new SendPayloadTask(reportBody, this.urlConfigurationService.resolveUrl(configuration.getDestination())).sendMessage(false);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public String getType() {
        return this.configurationService.getType();
    }

    @Generated
    public ReportCreator<T, C> getReportCreator() {
        return this.reportCreator;
    }
}

