/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.configuration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.Configuration;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String BANDANA_KEY = "com.moveworkforward.confluence.microsoftteams.notifier.configuration";
    private final BandanaManager bandanaManager;

    @Inject
    public ConfigurationManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public Configuration readConfiguration() {
        return this.readBandanaValue(ConfluenceBandanaContext.GLOBAL_CONTEXT, Configuration.class, new Configuration());
    }

    public void writeConfiguration(Configuration configuration) {
        this.writeBandanaValue(ConfluenceBandanaContext.GLOBAL_CONTEXT, configuration);
    }

    private void writeBandanaValue(ConfluenceBandanaContext bandanaContext, Object value) {
        String configurationJson = new Gson().toJson(value);
        this.bandanaManager.setValue((BandanaContext)bandanaContext, BANDANA_KEY, (Object)configurationJson);
        LOGGER.info("Wrote configuration {} with JSON {}", (Object)bandanaContext.getContextKey(), (Object)configurationJson);
    }

    private <T> T readBandanaValue(ConfluenceBandanaContext bandanaContext, Class<T> targetClass, T defaultValue) {
        Object fromBandana = this.bandanaManager.getValue((BandanaContext)bandanaContext, BANDANA_KEY, false);
        LOGGER.info("Read configuration {} with JSON {}.", (Object)bandanaContext.getContextKey(), fromBandana);
        try {
            return (T)new Gson().fromJson(fromBandana.toString(), targetClass);
        }
        catch (Exception e) {
            LOGGER.info("Using default configuration for {}.", targetClass);
            return defaultValue;
        }
    }
}

