/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.User;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@EntityType(value="CONFIGURATION")
public class StatisticsData
extends AbstractPluginEntity {
    public static final String TYPE = "CONFLUENCE_STATISTICS";
    public static final String SPACE_NAME = "spaceName";
    private String spaceKey;
    private String title;
    private String urlPath;
    private ContentType contentType;
    private long contentId;
    private long createTimestamp;
    private int viewCount;
    private long viewTimestamp;
    private int editCount;
    private long editTimestamp;
    private int commentCount;
    private long commentTimestamp;
    private int likeCount;
    private long likeTimestamp;
    private User author;
    private Map<String, Object> additionalInfo = new HashMap<String, Object>();
    private UserStatistics userStatistics = new UserStatistics();

    public StatisticsData(String spaceKey, ContentType contentType, long contentId) {
        this.spaceKey = spaceKey;
        this.contentType = contentType;
        this.contentId = contentId;
    }

    public StatisticsData(ContentType contentType, long contentId) {
        this.contentType = contentType;
        this.contentId = contentId;
    }

    public static String getKey(ContentType contentType, long contentId) {
        return (Object)((Object)contentType) + "_" + contentId;
    }

    public String getTag() {
        return StringUtils.isBlank((CharSequence)this.spaceKey) ? this.getKey() : this.spaceKey;
    }

    public String getKey() {
        return StatisticsData.getKey(this.contentType, this.contentId);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public long getContentId() {
        return this.contentId;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public long getViewTimestamp() {
        return this.viewTimestamp;
    }

    public int getEditCount() {
        return this.editCount;
    }

    public long getEditTimestamp() {
        return this.editTimestamp;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public long getCommentTimestamp() {
        return this.commentTimestamp;
    }

    public int getLikeCount() {
        return this.likeCount;
    }

    public long getLikeTimestamp() {
        return this.likeTimestamp;
    }

    public User getAuthor() {
        return this.author;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public UserStatistics getUserStatistics() {
        return this.userStatistics;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public void setViewCount(int viewCount) {
        this.viewCount = viewCount;
    }

    public void setViewTimestamp(long viewTimestamp) {
        this.viewTimestamp = viewTimestamp;
    }

    public void setEditCount(int editCount) {
        this.editCount = editCount;
    }

    public void setEditTimestamp(long editTimestamp) {
        this.editTimestamp = editTimestamp;
    }

    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }

    public void setCommentTimestamp(long commentTimestamp) {
        this.commentTimestamp = commentTimestamp;
    }

    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }

    public void setLikeTimestamp(long likeTimestamp) {
        this.likeTimestamp = likeTimestamp;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public void setUserStatistics(UserStatistics userStatistics) {
        this.userStatistics = userStatistics;
    }

    public String toString() {
        return "StatisticsData(super=" + super.toString() + ", spaceKey=" + this.spaceKey + ", title=" + this.title + ", urlPath=" + this.urlPath + ", contentType=" + (Object)((Object)this.contentType) + ", contentId=" + this.contentId + ", createTimestamp=" + this.createTimestamp + ", viewCount=" + this.viewCount + ", viewTimestamp=" + this.viewTimestamp + ", editCount=" + this.editCount + ", editTimestamp=" + this.editTimestamp + ", commentCount=" + this.commentCount + ", commentTimestamp=" + this.commentTimestamp + ", likeCount=" + this.likeCount + ", likeTimestamp=" + this.likeTimestamp + ", author=" + this.author + ", additionalInfo=" + this.additionalInfo + ", userStatistics=" + this.userStatistics + ")";
    }

    public StatisticsData() {
    }

    public static enum ContentType {
        PAGE(com.atlassian.confluence.api.model.content.ContentType.PAGE),
        BLOG_POST(com.atlassian.confluence.api.model.content.ContentType.BLOG_POST);

        private final com.atlassian.confluence.api.model.content.ContentType type;

        private ContentType(com.atlassian.confluence.api.model.content.ContentType type) {
            this.type = type;
        }

        public static ContentType fromConfluenceType(com.atlassian.confluence.api.model.content.ContentType type) {
            for (ContentType contentType : ContentType.values()) {
                if (!contentType.getType().getType().equals(type.getType())) continue;
                return contentType;
            }
            return null;
        }

        public com.atlassian.confluence.api.model.content.ContentType getType() {
            return this.type;
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserStatistics {
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> viewers = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> commentators = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> likers = new HashMap<User, Integer>();
        @JsonSerialize(keyUsing=User.UserAsAKeySerializer.class)
        @JsonDeserialize(keyUsing=User.UserAsAKeyDeserializer.class)
        private Map<User, Integer> editors = new HashMap<User, Integer>();

        public Map<User, Integer> getViewers() {
            return this.viewers;
        }

        public Map<User, Integer> getCommentators() {
            return this.commentators;
        }

        public Map<User, Integer> getLikers() {
            return this.likers;
        }

        public Map<User, Integer> getEditors() {
            return this.editors;
        }

        public void setViewers(Map<User, Integer> viewers) {
            this.viewers = viewers;
        }

        public void setCommentators(Map<User, Integer> commentators) {
            this.commentators = commentators;
        }

        public void setLikers(Map<User, Integer> likers) {
            this.likers = likers;
        }

        public void setEditors(Map<User, Integer> editors) {
            this.editors = editors;
        }

        public String toString() {
            return "StatisticsData.UserStatistics(viewers=" + this.viewers + ", commentators=" + this.commentators + ", likers=" + this.likers + ", editors=" + this.editors + ")";
        }
    }
}

