/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.configuration;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private static final int DEFAULT_LICENSE_NOTIFACATION_DAYS = 30;
    private boolean isDevMode;
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public LicenseManager(@ComponentImport PluginLicenseManager pluginLicenseManager, Environment environment) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
    }

    public boolean isLicensed() {
        boolean result = true;
        if (this.isDevMode) {
            log.info("Microsoft Teams Confluence Connector: License check is skipped");
        } else {
            Option license = this.pluginLicenseManager.getLicense();
            boolean bl = result = license.isDefined() && ((PluginLicense)license.get()).isValid();
        }
        if (result) {
            log.info("Microsoft Teams Confluence Connector: Plugin licensed.");
        } else {
            log.error("Microsoft Teams Confluence Connector: There is no valid licence");
        }
        return result;
    }

    public List<LicenseNotification> getLicenseNotifications() {
        ArrayList<LicenseNotification> notifications = new ArrayList<LicenseNotification>();
        Option lic = this.pluginLicenseManager.getLicense();
        if (lic != null) {
            if (lic.isDefined()) {
                PluginLicense license = (PluginLicense)lic.get();
                if (license.getError().isDefined()) {
                    Option error = license.getError();
                    Iterator iterator = error.iterator();
                    while (iterator.hasNext()) {
                        if (LicenseError.EXPIRED.equals(iterator.next())) {
                            notifications.add(new LicenseNotification(NotificationType.ERROR, "Your license of MS Teams Connector plugin has expired. Please contact your Administrator."));
                            continue;
                        }
                        notifications.add(new LicenseNotification(NotificationType.ERROR, "Your license of MS Teams Connector plugin is invalid. Please contact your Administrator."));
                    }
                } else {
                    Option period = ((PluginLicense)lic.get()).getExpiryDate();
                    for (DateTime date : period) {
                        if (!date.minusDays(30).isBefore((ReadableInstant)new DateTime())) continue;
                        if (license.getLicenseType().equals((Object)LicenseType.DEMONSTRATION)) {
                            notifications.add(new LicenseNotification(NotificationType.WARNING, "Your evaluation license of MS Teams Connector plugin will expire " + date.toLocalDate() + ". Please contact your Administrator."));
                            continue;
                        }
                        notifications.add(new LicenseNotification(NotificationType.WARNING, "Your license of MS Teams Connector plugin will expire " + date.toLocalDate() + ". Please contact your Administrator."));
                    }
                }
            } else {
                notifications.add(new LicenseNotification(NotificationType.ERROR, "Your license of MS Teams Connector plugin is not found. Please contact your Administrator."));
            }
        }
        return notifications;
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LicenseNotification {
        private NotificationType type;
        private String message;

        public NotificationType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public void setType(NotificationType type) {
            this.type = type;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LicenseNotification)) {
                return false;
            }
            LicenseNotification other = (LicenseNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NotificationType this$type = this.getType();
            NotificationType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LicenseNotification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NotificationType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "LicenseManager.LicenseNotification(type=" + (Object)((Object)this.getType()) + ", message=" + this.getMessage() + ")";
        }

        public LicenseNotification() {
        }

        public LicenseNotification(NotificationType type, String message) {
            this.type = type;
            this.message = message;
        }
    }

    public static enum NotificationType {
        ERROR,
        DEMONSTRATION,
        WARNING;

    }
}

