/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.event.PluginContentCreatedEvent;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import java.util.Optional;

public enum QuestionType {
    QUESTION("com.atlassian.confluence.plugins.confluence-questions:question"),
    ANSWER("com.atlassian.confluence.plugins.confluence-questions:answer");

    private String pluginModuleKey;

    private QuestionType(String pluginModuleKey) {
        this.pluginModuleKey = pluginModuleKey;
    }

    public static Optional<QuestionType> from(ConfluenceEvent confluenceEvent) {
        if (confluenceEvent.getClass().getName().equals("com.confluence.tiny.question.answer.services.QuestionEvent")) {
            return Optional.of(QUESTION);
        }
        if (confluenceEvent.getClass().getName().equals("com.confluence.tiny.question.answer.services.AnswerEvent")) {
            return Optional.of(ANSWER);
        }
        if (confluenceEvent instanceof PluginContentCreatedEvent) {
            return QuestionType.from(((PluginContentCreatedEvent)confluenceEvent).getContent());
        }
        return Optional.empty();
    }

    public static Optional<QuestionType> from(CustomContentEntityObject content) {
        if (QuestionType.isQuestionEvent(content)) {
            return Optional.of(QUESTION);
        }
        if (QuestionType.isAnswerEvent(content)) {
            return Optional.of(ANSWER);
        }
        return Optional.empty();
    }

    public static boolean isQuestionEvent(CustomContentEntityObject content) {
        return QuestionType.QUESTION.pluginModuleKey.equals(content.getPluginModuleKey());
    }

    public static boolean isAnswerEvent(CustomContentEntityObject content) {
        return QuestionType.ANSWER.pluginModuleKey.equals(content.getPluginModuleKey());
    }

    public String getPluginModuleKey() {
        return this.pluginModuleKey;
    }
}

