/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.MatchingStrategy;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigurationRule {
    private Integer id;
    private String key;
    private String spaceKey;
    private String webhookUrl;
    private Integer webhookUrlId;
    private List<BaseDestination> destinations = new ArrayList<BaseDestination>();
    private List<Source> events = new ArrayList<Source>();
    private String pathFilter;
    private String name;
    private NotificationRuleConfigurationGetRule configuration = new NotificationRuleConfigurationGetRule();
    private Boolean enabled = true;
    private Boolean minimalContent = false;
    private boolean expandedCard;
    private boolean viewActionsButton = true;

    public ConfigurationRule() {
        this.destinations.add(new BaseDestination());
    }

    public ConfigurationRule(Configuration dto) {
        this.id = dto.getId();
        this.key = dto.getKey();
        this.spaceKey = dto.getSpaceKey();
        this.destinations = new ArrayList<BaseDestination>(dto.getDestinations());
        this.webhookUrl = dto.getDestination().getUrl();
        this.webhookUrlId = dto.getDestination().getUrlId();
        this.events = dto.getEvents();
        this.pathFilter = dto.getPathFilter();
        this.name = dto.getName();
        this.enabled = dto.isEnabled();
        this.minimalContent = dto.isMinimalContent();
        this.expandedCard = dto.isExpandedCard();
        this.viewActionsButton = dto.isViewActionsButton();
        this.configuration.filters.labels = dto.getConfiguration().getFilters().getLabels();
        this.configuration.filters.labelMatchingStrategy = dto.getConfiguration().getFilters().getLabelMatchingStrategy();
        this.configuration.filters.topics = dto.getConfiguration().getFilters().getTopics();
        this.configuration.filters.topicMatchingStrategy = dto.getConfiguration().getFilters().getTopicMatchingStrategy();
        this.configuration.filters.parentPageId = dto.getConfiguration().getFilters().getParentPageId();
        this.configuration.filters.excludeGroupNames = dto.getConfiguration().getFilters().getExcludeGroupNames();
        this.configuration.filters.includeGroupNames = dto.getConfiguration().getFilters().getIncludeGroupNames();
        this.configuration.filters.includeUsers = dto.getConfiguration().getFilters().getIncludeUsers();
        this.configuration.filters.excludeUsers = dto.getConfiguration().getFilters().getExcludeUsers();
    }

    public Integer getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public Integer getWebhookUrlId() {
        return this.webhookUrlId;
    }

    public List<BaseDestination> getDestinations() {
        return this.destinations;
    }

    public List<Source> getEvents() {
        return this.events;
    }

    public String getPathFilter() {
        return this.pathFilter;
    }

    public String getName() {
        return this.name;
    }

    public NotificationRuleConfigurationGetRule getConfiguration() {
        return this.configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getMinimalContent() {
        return this.minimalContent;
    }

    public boolean isExpandedCard() {
        return this.expandedCard;
    }

    public boolean isViewActionsButton() {
        return this.viewActionsButton;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setWebhookUrlId(Integer webhookUrlId) {
        this.webhookUrlId = webhookUrlId;
    }

    public void setDestinations(List<BaseDestination> destinations) {
        this.destinations = destinations;
    }

    public void setEvents(List<Source> events) {
        this.events = events;
    }

    public void setPathFilter(String pathFilter) {
        this.pathFilter = pathFilter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfiguration(NotificationRuleConfigurationGetRule configuration) {
        this.configuration = configuration;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setMinimalContent(Boolean minimalContent) {
        this.minimalContent = minimalContent;
    }

    public void setExpandedCard(boolean expandedCard) {
        this.expandedCard = expandedCard;
    }

    public void setViewActionsButton(boolean viewActionsButton) {
        this.viewActionsButton = viewActionsButton;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationRule)) {
            return false;
        }
        ConfigurationRule other = (ConfigurationRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExpandedCard() != other.isExpandedCard()) {
            return false;
        }
        if (this.isViewActionsButton() != other.isViewActionsButton()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$webhookUrlId = this.getWebhookUrlId();
        Integer other$webhookUrlId = other.getWebhookUrlId();
        if (this$webhookUrlId == null ? other$webhookUrlId != null : !((Object)this$webhookUrlId).equals(other$webhookUrlId)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$minimalContent = this.getMinimalContent();
        Boolean other$minimalContent = other.getMinimalContent();
        if (this$minimalContent == null ? other$minimalContent != null : !((Object)this$minimalContent).equals(other$minimalContent)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$spaceKey = this.getSpaceKey();
        String other$spaceKey = other.getSpaceKey();
        if (this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey)) {
            return false;
        }
        String this$webhookUrl = this.getWebhookUrl();
        String other$webhookUrl = other.getWebhookUrl();
        if (this$webhookUrl == null ? other$webhookUrl != null : !this$webhookUrl.equals(other$webhookUrl)) {
            return false;
        }
        List<BaseDestination> this$destinations = this.getDestinations();
        List<BaseDestination> other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        List<Source> this$events = this.getEvents();
        List<Source> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        String this$pathFilter = this.getPathFilter();
        String other$pathFilter = other.getPathFilter();
        if (this$pathFilter == null ? other$pathFilter != null : !this$pathFilter.equals(other$pathFilter)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NotificationRuleConfigurationGetRule this$configuration = this.getConfiguration();
        NotificationRuleConfigurationGetRule other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExpandedCard() ? 79 : 97);
        result = result * 59 + (this.isViewActionsButton() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $webhookUrlId = this.getWebhookUrlId();
        result = result * 59 + ($webhookUrlId == null ? 43 : ((Object)$webhookUrlId).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $minimalContent = this.getMinimalContent();
        result = result * 59 + ($minimalContent == null ? 43 : ((Object)$minimalContent).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $spaceKey = this.getSpaceKey();
        result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
        String $webhookUrl = this.getWebhookUrl();
        result = result * 59 + ($webhookUrl == null ? 43 : $webhookUrl.hashCode());
        List<BaseDestination> $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        List<Source> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        String $pathFilter = this.getPathFilter();
        result = result * 59 + ($pathFilter == null ? 43 : $pathFilter.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NotificationRuleConfigurationGetRule $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigurationRule(id=" + this.getId() + ", key=" + this.getKey() + ", spaceKey=" + this.getSpaceKey() + ", webhookUrl=" + this.getWebhookUrl() + ", webhookUrlId=" + this.getWebhookUrlId() + ", destinations=" + this.getDestinations() + ", events=" + this.getEvents() + ", pathFilter=" + this.getPathFilter() + ", name=" + this.getName() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", minimalContent=" + this.getMinimalContent() + ", expandedCard=" + this.isExpandedCard() + ", viewActionsButton=" + this.isViewActionsButton() + ")";
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public class NotificationFiltersGetRule {
        private List<String> includeGroupNames = new ArrayList<String>();
        private List<User> includeUsers = new ArrayList<User>();
        private List<String> excludeGroupNames = new ArrayList<String>();
        private List<User> excludeUsers = new ArrayList<User>();
        private MatchingStrategy labelMatchingStrategy = MatchingStrategy.ALL;
        private List<String> labels = new ArrayList<String>();
        private MatchingStrategy topicMatchingStrategy = MatchingStrategy.ALL;
        private List<String> topics = new ArrayList<String>();
        private String parentPageId = null;

        public List<String> getIncludeGroupNames() {
            return this.includeGroupNames;
        }

        public List<User> getIncludeUsers() {
            return this.includeUsers;
        }

        public List<String> getExcludeGroupNames() {
            return this.excludeGroupNames;
        }

        public List<User> getExcludeUsers() {
            return this.excludeUsers;
        }

        public MatchingStrategy getLabelMatchingStrategy() {
            return this.labelMatchingStrategy;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public MatchingStrategy getTopicMatchingStrategy() {
            return this.topicMatchingStrategy;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        public String getParentPageId() {
            return this.parentPageId;
        }

        public void setIncludeGroupNames(List<String> includeGroupNames) {
            this.includeGroupNames = includeGroupNames;
        }

        public void setIncludeUsers(List<User> includeUsers) {
            this.includeUsers = includeUsers;
        }

        public void setExcludeGroupNames(List<String> excludeGroupNames) {
            this.excludeGroupNames = excludeGroupNames;
        }

        public void setExcludeUsers(List<User> excludeUsers) {
            this.excludeUsers = excludeUsers;
        }

        public void setLabelMatchingStrategy(MatchingStrategy labelMatchingStrategy) {
            this.labelMatchingStrategy = labelMatchingStrategy;
        }

        public void setLabels(List<String> labels) {
            this.labels = labels;
        }

        public void setTopicMatchingStrategy(MatchingStrategy topicMatchingStrategy) {
            this.topicMatchingStrategy = topicMatchingStrategy;
        }

        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public void setParentPageId(String parentPageId) {
            this.parentPageId = parentPageId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationFiltersGetRule)) {
                return false;
            }
            NotificationFiltersGetRule other = (NotificationFiltersGetRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$includeGroupNames = this.getIncludeGroupNames();
            List<String> other$includeGroupNames = other.getIncludeGroupNames();
            if (this$includeGroupNames == null ? other$includeGroupNames != null : !((Object)this$includeGroupNames).equals(other$includeGroupNames)) {
                return false;
            }
            List<User> this$includeUsers = this.getIncludeUsers();
            List<User> other$includeUsers = other.getIncludeUsers();
            if (this$includeUsers == null ? other$includeUsers != null : !((Object)this$includeUsers).equals(other$includeUsers)) {
                return false;
            }
            List<String> this$excludeGroupNames = this.getExcludeGroupNames();
            List<String> other$excludeGroupNames = other.getExcludeGroupNames();
            if (this$excludeGroupNames == null ? other$excludeGroupNames != null : !((Object)this$excludeGroupNames).equals(other$excludeGroupNames)) {
                return false;
            }
            List<User> this$excludeUsers = this.getExcludeUsers();
            List<User> other$excludeUsers = other.getExcludeUsers();
            if (this$excludeUsers == null ? other$excludeUsers != null : !((Object)this$excludeUsers).equals(other$excludeUsers)) {
                return false;
            }
            MatchingStrategy this$labelMatchingStrategy = this.getLabelMatchingStrategy();
            MatchingStrategy other$labelMatchingStrategy = other.getLabelMatchingStrategy();
            if (this$labelMatchingStrategy == null ? other$labelMatchingStrategy != null : !((Object)((Object)this$labelMatchingStrategy)).equals((Object)other$labelMatchingStrategy)) {
                return false;
            }
            List<String> this$labels = this.getLabels();
            List<String> other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
                return false;
            }
            MatchingStrategy this$topicMatchingStrategy = this.getTopicMatchingStrategy();
            MatchingStrategy other$topicMatchingStrategy = other.getTopicMatchingStrategy();
            if (this$topicMatchingStrategy == null ? other$topicMatchingStrategy != null : !((Object)((Object)this$topicMatchingStrategy)).equals((Object)other$topicMatchingStrategy)) {
                return false;
            }
            List<String> this$topics = this.getTopics();
            List<String> other$topics = other.getTopics();
            if (this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics)) {
                return false;
            }
            String this$parentPageId = this.getParentPageId();
            String other$parentPageId = other.getParentPageId();
            return !(this$parentPageId == null ? other$parentPageId != null : !this$parentPageId.equals(other$parentPageId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotificationFiltersGetRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $includeGroupNames = this.getIncludeGroupNames();
            result = result * 59 + ($includeGroupNames == null ? 43 : ((Object)$includeGroupNames).hashCode());
            List<User> $includeUsers = this.getIncludeUsers();
            result = result * 59 + ($includeUsers == null ? 43 : ((Object)$includeUsers).hashCode());
            List<String> $excludeGroupNames = this.getExcludeGroupNames();
            result = result * 59 + ($excludeGroupNames == null ? 43 : ((Object)$excludeGroupNames).hashCode());
            List<User> $excludeUsers = this.getExcludeUsers();
            result = result * 59 + ($excludeUsers == null ? 43 : ((Object)$excludeUsers).hashCode());
            MatchingStrategy $labelMatchingStrategy = this.getLabelMatchingStrategy();
            result = result * 59 + ($labelMatchingStrategy == null ? 43 : ((Object)((Object)$labelMatchingStrategy)).hashCode());
            List<String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            MatchingStrategy $topicMatchingStrategy = this.getTopicMatchingStrategy();
            result = result * 59 + ($topicMatchingStrategy == null ? 43 : ((Object)((Object)$topicMatchingStrategy)).hashCode());
            List<String> $topics = this.getTopics();
            result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
            String $parentPageId = this.getParentPageId();
            result = result * 59 + ($parentPageId == null ? 43 : $parentPageId.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationRule.NotificationFiltersGetRule(includeGroupNames=" + this.getIncludeGroupNames() + ", includeUsers=" + this.getIncludeUsers() + ", excludeGroupNames=" + this.getExcludeGroupNames() + ", excludeUsers=" + this.getExcludeUsers() + ", labelMatchingStrategy=" + (Object)((Object)this.getLabelMatchingStrategy()) + ", labels=" + this.getLabels() + ", topicMatchingStrategy=" + (Object)((Object)this.getTopicMatchingStrategy()) + ", topics=" + this.getTopics() + ", parentPageId=" + this.getParentPageId() + ")";
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public class NotificationRuleConfigurationGetRule {
        @JsonProperty(value="filters")
        private NotificationFiltersGetRule filters;

        public NotificationFiltersGetRule getFilters() {
            return this.filters;
        }

        public void setFilters(NotificationFiltersGetRule filters) {
            this.filters = filters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationRuleConfigurationGetRule)) {
                return false;
            }
            NotificationRuleConfigurationGetRule other = (NotificationRuleConfigurationGetRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NotificationFiltersGetRule this$filters = this.getFilters();
            NotificationFiltersGetRule other$filters = other.getFilters();
            return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotificationRuleConfigurationGetRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NotificationFiltersGetRule $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationRule.NotificationRuleConfigurationGetRule(filters=" + this.getFilters() + ")";
        }

        public NotificationRuleConfigurationGetRule() {
            this.filters = new NotificationFiltersGetRule();
        }
    }
}

