/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.util;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DateTimeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtil.class);
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;

    @Inject
    public DateTimeUtil(@ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager) {
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.getDateTimeFormatter(FormatStyle.LONG);
    }

    public DateTimeFormatter getDateTimeFormatter(FormatStyle formatStyle) {
        return DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(this.localeManager.getSiteDefaultLocale());
    }

    public String formatDate(Date date) {
        try {
            ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
            LocalDate localDate = LocalDate.from(date.toInstant().atZone(zone));
            return this.getDateTimeFormatter(FormatStyle.SHORT).format(localDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getPrettyDate(long epochMillis, ZoneId zone) {
        return this.getDateTimeFormatter().format(Instant.ofEpochMilli(epochMillis).atZone(zone));
    }

    public String getDates(long startDate, long endDate, boolean allDay) {
        ZoneId zone = this.timeZoneManager.getDefaultTimeZone().toZoneId();
        LocalDate start = LocalDate.from(Instant.ofEpochMilli(startDate).atZone(ZoneOffset.UTC));
        LocalDate end = LocalDate.from(Instant.ofEpochMilli(endDate).atZone(ZoneOffset.UTC));
        DateTimeFormatter formatter = this.getDateTimeFormatter();
        if (allDay) {
            LocalDate realEnd = end.minusDays(1L);
            if (start.isEqual(realEnd)) {
                return formatter.format(Instant.ofEpochMilli(start.atStartOfDay(zone).toEpochSecond() * 1000L).atZone(zone));
            }
            return "from " + this.getPrettyDate(start.atStartOfDay(zone).toEpochSecond() * 1000L, zone) + " to " + this.getPrettyDate(realEnd.atStartOfDay(zone).toEpochSecond() * 1000L, zone);
        }
        if (start.isEqual(end)) {
            return "in " + this.getPrettyDate(startDate, zone) + " from " + this.getPrettyDate(startDate, zone) + " to " + this.getPrettyDate(endDate, zone);
        }
        return "from " + this.getPrettyDate(startDate, zone) + " at " + this.getPrettyDate(startDate, zone) + " to " + this.getPrettyDate(endDate, zone) + " at " + this.getPrettyDate(endDate, zone);
    }
}

