/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UrlConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.User;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.service.ConfigurationAuditService;
import com.moveworkforward.service.ConfigurationService;
import com.moveworkforward.service.impl.AbstractGlobalSettingsService;
import com.moveworkforward.service.impl.AbstractUrlConfigurationService;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UrlConfigurationServiceImpl
extends AbstractUrlConfigurationService<UrlConfiguration, BaseDestination> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlConfigurationServiceImpl.class);
    protected final UserAccessor userAccessor;

    @Inject
    public UrlConfigurationServiceImpl(PluginSettingRepository<UrlConfiguration> repository, ConfigurationAuditService auditService, GeneralConfluenceValidationHelper validationHelper, GlobalSettingsService confluenceGlobalSettings, List<ConfigurationService<? extends PluginEntity>> configurationServices, @ComponentImport UserAccessor userAccessor) {
        super(repository, auditService, (ValidationHelper)validationHelper, (AbstractGlobalSettingsService)confluenceGlobalSettings, configurationServices);
        this.userAccessor = userAccessor;
    }

    protected void doEnhancement(UrlConfiguration configuration) {
        configuration.setOwner(this.enrichUser(configuration.getOwner()));
        this.enrichUsers(configuration.getUsers());
    }

    protected String createTestPayload() {
        String text = "Microsoft Teams Confluence Connector url test. Please ignore.";
        MessageData messageData = new MessageData(text, text, null);
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        return ConnectorUtil.createObjectMapper((boolean)true).writeValueAsString((Object)message);
    }

    protected void enrichUsers(List<User> users) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        users.forEach(this::enrichUser);
    }

    protected User enrichUser(User user) {
        try {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(user.getUserKey()));
            if (confluenceUser != null) {
                user.setDisplayName(confluenceUser.getFullName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }
}

