/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.HistoricalStatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ProgressStatisticDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ProgressStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ProgressStatisticReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ProgressStatisticReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.util.CqlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProgressStatisticReportExecutor
extends AbstractReportExecutor<ProgressStatisticReportConfiguration, ProgressStatisticDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressStatisticReportExecutor.class);
    private final CQLSearchService searchService;
    private final StatisticService statisticService;

    @Inject
    public ProgressStatisticReportExecutor(ProgressStatisticReportConfigurationService configurationService, UrlConfigurationServiceImpl urlConfigurationService, ProgressStatisticReportCreator reportCreator, @ComponentImport CQLSearchService searchService, StatisticService statisticService) {
        super(configurationService, urlConfigurationService, reportCreator);
        this.searchService = searchService;
        this.statisticService = statisticService;
        this.isReschedule = true;
    }

    @Override
    protected ProgressStatisticDataHolder getPayloadDataByConfiguration(ProgressStatisticReportConfiguration configuration, Date date) {
        ProgressStatisticDataHolder dataHolder = new ProgressStatisticDataHolder();
        List<Content> contents = this.getContentByCql(configuration);
        contents.forEach(content -> {
            StatisticsData statisticsData = this.statisticService.get(StatisticsData.ContentType.fromConfluenceType(content.getType()), content.getId().asLong());
            if (statisticsData != null) {
                HistoricalStatisticsData historicalStatisticsData = this.statisticService.getHistoryByKey(HistoricalStatisticsData.getKey(configuration.getId(), statisticsData));
                ImmutablePair pair = ImmutablePair.of((Object)((Object)statisticsData), (Object)((Object)historicalStatisticsData));
                dataHolder.getData().add((Pair<StatisticsData, HistoricalStatisticsData>)pair);
            }
        });
        return dataHolder;
    }

    @Override
    protected void postExecute(Map<ProgressStatisticReportConfiguration, ProgressStatisticDataHolder> dataPerConfiguration, List<ProgressStatisticReportConfiguration> configurations, List<ProgressStatisticReportConfiguration> errorConfigurations) {
        super.postExecute(dataPerConfiguration, configurations, errorConfigurations);
        dataPerConfiguration.forEach((configuration, progressStatisticDataHolder) -> {
            if (progressStatisticDataHolder != null && !progressStatisticDataHolder.isEmpty()) {
                progressStatisticDataHolder.getData().forEach(d -> {
                    HistoricalStatisticsData historicalStatisticsData = (HistoricalStatisticsData)((Object)((Object)((Object)d.getValue())));
                    if (historicalStatisticsData == null) {
                        historicalStatisticsData = new HistoricalStatisticsData();
                        historicalStatisticsData.setConfigurationId(configuration.getId());
                    }
                    historicalStatisticsData.setStatisticsData((StatisticsData)((Object)((Object)((Object)d.getKey()))));
                    historicalStatisticsData.setDate(new Date());
                    this.statisticService.saveHistory(historicalStatisticsData);
                });
            }
        });
    }

    private List<Content> getContentByCql(ProgressStatisticReportConfiguration configuration) {
        StringBuilder cqlBuilder = new StringBuilder();
        List<String> authors = configuration.getAuthors().stream().map(user -> ((ConfluenceUser)user.getUser()).getName()).collect(Collectors.toList());
        CqlUtils.addInCriteria(cqlBuilder, "creator", authors, false);
        if (CollectionUtils.isNotEmpty((Collection)configuration.getSources())) {
            List<String> ids = configuration.getSources().stream().filter(s -> StatisticsData.ContentType.PAGE.equals((Object)s.getContentType())).map(s -> String.valueOf(s.getContentId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                CqlUtils.appendCriteria(cqlBuilder);
                cqlBuilder.append("(type = page");
                CqlUtils.addInCriteria(cqlBuilder, "id", ids, false);
                cqlBuilder.append(")");
            }
            if (CollectionUtils.isNotEmpty(ids = configuration.getSources().stream().filter(s -> StatisticsData.ContentType.BLOG_POST.equals((Object)s.getContentType())).map(s -> String.valueOf(s.getContentId())).collect(Collectors.toList()))) {
                CqlUtils.appendCriteria(cqlBuilder);
                cqlBuilder.append("(type = blogpost");
                CqlUtils.addInCriteria(cqlBuilder, "id", ids, false);
                cqlBuilder.append(")");
            }
        }
        cqlBuilder.append(" order by created desc");
        log.debug("CQL: {}", (Object)cqlBuilder.toString());
        List<Content> result = new ArrayList();
        try (AutoCloseable context = AuthenticatedUserThreadLocal.asUser((ConfluenceUser)((ConfluenceUser)configuration.getOwner().getUser()));){
            PageResponse pageResponse = this.searchService.searchContent(cqlBuilder.toString(), (PageRequest)new SimplePageRequest(0, configuration.getContentAmount()), new Expansion[0]);
            result = pageResponse.getResults();
        }
        log.debug("Found content items: {}", (Object)result.size());
        return result;
    }
}

