/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.event.events.like.LikeCreatedEvent;
import com.atlassian.confluence.event.events.like.LikeRemovedEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsEvent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsEvent.class);
    private final ContentEvent contentEvent;
    private final EventType eventType;

    public StatisticsEvent(ContentEvent contentEvent) {
        this.contentEvent = contentEvent;
        this.eventType = EventType.fromContentEvent(contentEvent);
    }

    @Generated
    public ContentEvent getContentEvent() {
        return this.contentEvent;
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    public static enum EventType {
        PAGE_CREATE(PageCreateEvent.class),
        PAGE_VIEW(PageViewEvent.class),
        PAGE_UPDATE(PageUpdateEvent.class),
        BLOG_POST_CREATE(BlogPostCreateEvent.class),
        BLOG_POST_VIEW(BlogPostViewEvent.class),
        BLOG_POST_UPDATE(BlogPostUpdateEvent.class),
        COMMENT_CREATE(CommentCreateEvent.class),
        COMMENT_UPDATE(CommentUpdateEvent.class),
        COMMENT_REMOVE(CommentRemoveEvent.class),
        LIKE_REMOVED(LikeRemovedEvent.class),
        LIKE_CREATED(LikeCreatedEvent.class);

        private final Class<? extends ContentEvent> eventClass;

        private EventType(Class<? extends ContentEvent> eventClass) {
            this.eventClass = eventClass;
        }

        public static EventType fromContentEvent(ContentEvent contentEvent) {
            for (EventType value : EventType.values()) {
                if (!value.eventClass.isAssignableFrom(contentEvent.getClass())) continue;
                log.debug("Content event {}, value {}", (Object)contentEvent, (Object)value);
                return value;
            }
            throw new RuntimeException("Value is not found for class: " + contentEvent.getClass());
        }
    }
}

