/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.listeners;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.event.events.like.AbstractLikeEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.listeners.AutoSubscribingEventListener;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class StatisticsListener
extends AutoSubscribingEventListener {
    private final StatisticService statisticService;

    @Inject
    public StatisticsListener(@ComponentImport EventPublisher eventPublisher, StatisticService statisticService) {
        super(eventPublisher);
        this.statisticService = statisticService;
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void pageViewEvent(PageViewEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void blogPostViewEvent(BlogPostViewEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void commentEvent(CommentEvent event) {
        this.process((ContentEvent)event);
    }

    @EventListener
    public void likeEvent(AbstractLikeEvent event) {
        this.process((ContentEvent)event);
    }

    private void process(ContentEvent contentEvent) {
        this.statisticService.process(new StatisticsEvent(contentEvent));
    }
}

