/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsReminderAlertConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.StatisticsReminderAlertConfigurationRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.service.ConfigurationAuditService;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StatisticsReminderReportConfigurationService
extends AbstractStatisticsReportConfigurationService<StatisticsReminderAlertConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsReminderReportConfigurationService.class);

    @Inject
    public StatisticsReminderReportConfigurationService(StatisticsReminderAlertConfigurationRepository repository, ConfigurationAuditService auditService, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager) {
        super(repository, auditService, validationHelper, userAccessor, pageManager, spaceManager);
    }

    @Override
    public void validate(StatisticsReminderAlertConfiguration configuration) {
        super.validate(configuration);
        configuration.getSources().forEach(s -> {
            if (s.getContentType() == null || s.getContentId() == null) {
                throw new IllegalArgumentException("Content type and content ID must be specified");
            }
        });
        if (configuration.getThreshold() <= 0) {
            throw new IllegalArgumentException("Threshold must be greater than 0");
        }
    }

    @Override
    public boolean shouldProcess(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        StatisticsData.ContentType contentType = StatisticService.getContentType(content);
        long contentId = content.getId();
        List configurations = this.pluginRepository.getAll();
        boolean result = configurations.stream().anyMatch(c -> !CollectionUtils.isEmpty((Collection)c.getSources()) && c.getSources().stream().anyMatch(s -> contentType.equals((Object)s.getContentType()) && contentId == s.getContentId()));
        log.debug("Content type: {}, content ID: {}, should process: {}", new Object[]{contentType, contentId, result});
        return result;
    }

    public String getType() {
        return "statistics-reminder-alert";
    }

    public Class<StatisticsReminderAlertConfiguration> getConfigurationClass() {
        return StatisticsReminderAlertConfiguration.class;
    }
}

