/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UrlConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.UrlTestResponse;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="urls")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class UrlConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(UrlConfigurationController.class);
    private static final boolean CHECK_PERMISSIONS = true;
    protected final PermissionManager permissionManager;
    private final UrlConfigurationServiceImpl configurationService;

    @Inject
    public UrlConfigurationController(UrlConfigurationServiceImpl urlConfigurationService, @ComponentImport PermissionManager permissionManager) {
        this.configurationService = urlConfigurationService;
        this.permissionManager = permissionManager;
    }

    @GET
    public List<UrlConfiguration> getConfigurationsForSettings(@QueryParam(value="spaceKey") String spaceKey) {
        return this.configurationService.getConfigurationsForSettings(spaceKey);
    }

    @Path(value="/suggestion")
    @GET
    public List<UrlConfiguration> getConfigurationsForSuggestion(@QueryParam(value="spaceKey") String spaceKey) {
        return this.configurationService.getConfigurationsForSuggestion(spaceKey);
    }

    @Path(value="/personal")
    @GET
    public List<UrlConfiguration> getPersonalConfigurations(@QueryParam(value="userKey") String userKey) {
        return this.configurationService.getPersonalConfigurations(userKey);
    }

    @POST
    public UrlConfiguration saveUrlConfiguration(UrlConfiguration configuration) {
        log.debug("saveUrlConfiguration saving: {}", (Object)configuration);
        UrlConfiguration result = (UrlConfiguration)this.configurationService.save(configuration, true);
        log.debug("saveUrlConfiguration saved: {}", (Object)result);
        return result;
    }

    @Path(value="/{id}")
    @DELETE
    public void deleteConfigurationById(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        UrlConfiguration deleted = (UrlConfiguration)this.configurationService.delete(id, true);
        log.debug("Deleted url configuration: {}", (Object)deleted);
    }

    @Path(value="/{id}")
    @GET
    public UrlConfiguration getUrlConfigurationById(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        log.debug("getUrlConfigurationById input: {}", (Object)id);
        UrlConfiguration result = (UrlConfiguration)this.configurationService.get(id, true);
        log.debug("getUrlConfigurationById result: {}", (Object)result);
        return result;
    }

    @Path(value="/test")
    @POST
    public UrlTestResponse testUrl(BaseDestination urlTestHolder, @QueryParam(value="showDetails") boolean showDetails) {
        return this.configurationService.testUrl(urlTestHolder, showDetails);
    }
}

