/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ModelVersion;
import com.moveworkforward.ao.AbstractUpgradeTask;
import com.moveworkforward.ao.entity.ReportEntity;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeTask3
extends AbstractUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask3.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{ReportEntity.class});
        ReportEntity[] entities = (ReportEntity[])activeObjects.find(ReportEntity.class, Query.select().where("TYPE = ?", new Object[]{"task_reminder_configuration"}));
        if (entities == null) {
            log.info("Nothing to migrate for version 3");
            return;
        }
        for (ReportEntity entity : entities) {
            try {
                log.info("{} configurations for migration", (Object)entity.getContent());
                entity.setType("task-reminder-report");
                entity.save();
            }
            catch (Exception e) {
                log.error("Can't migrate configuration " + entity.getContent(), (Throwable)e);
            }
        }
    }
}

